# -*- coding: UTF-8 -*-
import cliUtil
import common
import os
import time
import traceback

from com.huawei.ism.tool.obase.exception import ToolException
import com.huawei.ism.tool.obase.connection.SftpTransporter as SftpCls


def fetchEventLog2Local(PY_JAVA_ENV, cli, LOGGER, LANG):
    """
    @summary: Download event log using show file command
    @return: isSuccess
    """
    echo = ""
    cmd = "show file export_path file_type=event"
    localPath = ""

    try:
        remotePath = ""
        resultStatus, echo, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if resultStatus != True or "file path :" not in echo.lower():
            LOGGER.logError("failed to execute show command or echos do not contain file path .")
            return False, localPath, common.getMsg(LANG, "faild.fetch.event.log.export.destination")
        for line in echo.splitlines():
            if "file path" in line.lower() and len(line.split(":")) > 1:
                remotePath = line.split(":")[1].strip()
                LOGGER.logInfo("found remote file location: %s" % str(remotePath))
        if not remotePath:
            LOGGER.logError("failed to parse file path placeholder.")
            return False, localPath, common.getMsg(LANG, "faild.fetch.event.log.export.destination")

        localTmpDir = PY_JAVA_ENV.get("dataCollectTmpDir")
        if not localTmpDir:
            devNode = PY_JAVA_ENV.get("devInfo")
            localTmpDir = os.path.join('pytemp' ,
                   devNode.getDeviceSerialNumber() + "_" + time.strftime('%Y%m%d%H%M%S', time.localtime(time.time())))
            PY_JAVA_ENV['dataCollectTmpDir'] = localTmpDir

        if not os.path.exists(localTmpDir):
            os.makedirs(localTmpDir)
        fileName = remotePath.split("/")[-1]
        LOGGER.logInfo("current inspect temp dir list as: %s" % str(localTmpDir))
        sftp = SftpCls(cli)
        try:
            sftp.getFile(remotePath, localTmpDir, None)
        except:
            LOGGER.logError("failed to download:\n trace back:" + unicode(traceback.format_exc()))
            return False, localPath, common.getMsg(LANG, "faild.fetch.event.log.export.destination")
        finally:
            if sftp:
                sftp.close()

        try:
            deleteTempFile(cli, LANG)
        except:
            LOGGER.logError("delete remote file error:\n trace back:" + unicode(traceback.format_exc()))
        localPath = os.path.join(localTmpDir, fileName)
        LOGGER.logInfo("file successfully download to local: %s " % str(localPath))

        return True, localPath, ""
    except:
        errMsg = common.getMsg(LANG, "faild.fetch.event.log.export.destination")
        LOGGER.logError("except trace back:" + unicode(traceback.format_exc()))
        return False, localPath, errMsg


def deleteTempFile(cli, LANG):
    """
    @summary: Delete temporary files on the device
    """
    cmd = "delete file filetype=event"
    cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)



def fetchLog2Local(cmd, deleteCmd, PY_JAVA_ENV, cli, LOGGER, LANG):
    """
    @summary: Download event log using show file command
    @return: isSuccess
    """
    echo = ""
    localPath = ""

    try:
        remotePath = ""
        __, cliRet, __ = deleteTempDataFile(deleteCmd, cli, LANG)
        resultStatus, echo, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if resultStatus != True or "file path :" not in echo.lower():
            LOGGER.logError("failed to execute show command or echos do not contain file path .")
            return False, localPath, echo, common.getMsg(LANG, "faild.fetch.event.log.export.destination")
        for line in echo.splitlines():
            if "file path" in line.lower() and len(line.split(":")) > 1:
                remotePath = line.split(":")[1].strip()
                LOGGER.logInfo("found remote file location: %s" % str(remotePath))
        if not remotePath:
            LOGGER.logError("failed to parse file path placeholder.")
            return False, localPath, echo, common.getMsg(LANG, "faild.fetch.event.log.export.destination")

        localTmpDir = PY_JAVA_ENV.get("dataCollectTmpDir")
        if not localTmpDir:
            devNode = PY_JAVA_ENV.get("devInfo")
            localTmpDir = os.path.join('pytemp' ,
                   devNode.getDeviceSerialNumber() + "_" + time.strftime('%Y%m%d%H%M%S', time.localtime(time.time())))
            PY_JAVA_ENV['dataCollectTmpDir'] = localTmpDir

        if not os.path.exists(localTmpDir):
            os.makedirs(localTmpDir)
        fileName = remotePath.split("/")[-1]
        LOGGER.logInfo("current inspect temp dir list as: %s" % str(localTmpDir))
        sftp = SftpCls(cli)
        try:
            sftp.getFile(remotePath, localTmpDir, None)
        except:
            LOGGER.logError("failed to download:\n trace back:" + unicode(
                traceback.format_exc()))
            return False, localPath, common.getMsg(
                LANG, "faild.fetch.event.log.export.destination")
        finally:
            if sftp:
                sftp.close()
        try:
            __, cliRet, __ = deleteTempDataFile(deleteCmd, cli, LANG)
            echo += "\n" + cliRet
        except:
            LOGGER.logError("delete remote file error:\n trace back:" + unicode(traceback.format_exc()))
        localPath = os.path.join(localTmpDir, fileName)
        LOGGER.logInfo("file successfully download to local: %s " % str(localPath))

        return True, localPath, echo, ""
    except:
        errMsg = common.getMsg(LANG, "faild.fetch.event.log.export.destination")
        LOGGER.logError("except trace back:" + unicode(traceback.format_exc()))
        return False, localPath, echo, errMsg


def deleteTempDataFile(deleteCmd, cli, LANG):
    """
    @summary: Delete temporary files on the device
    """
    return cliUtil.excuteCmdInCliMode(cli, deleteCmd, True, LANG)


def collect_running_data(sftp, cli, lang, local_path, sn, logger):
    """
    收集config.txt文件
    :param sftp: 下载连接sftp
    :param cli: cli连接
    :param lang: 语言
    :param local_path: 下载的本地路径
    :param sn: 序列号
    :param logger: 日志
    :return:
    """
    local_res_path = ""
    remote_path = ""
    try:
        collect_cmd = "show file export_path file_type=running_data"
        del_cmd = "delete file filetype=running_data"
        deleteTempDataFile(del_cmd, cli, lang)
        flag, ret, msg = cliUtil.excuteCmdInCliMode(cli, collect_cmd, True,
                                                    lang)
        if flag is not True or "file path :" not in ret.lower():
            return False, local_res_path, msg

        for line in ret.splitlines():
            if "file path" in line.lower() and len(line.split(":")) > 1:
                remote_path = line.split(":")[1].strip()

        if not remote_path:
            msg_key = "faild.fetch.event.log.export.destination"
            return False, local_res_path, common.getMsg(lang, msg_key)

        if not os.path.exists(local_path):
            os.makedirs(local_path)

        remote_file_name = remote_path.split("/")[-1]
        file_name = "{0}_{1}".format(sn, remote_file_name)
        local_res_path = os.path.join(local_path, file_name)
        sftp.getFile(remote_path, local_res_path, None)
        deleteTempDataFile(del_cmd, cli, lang)
        return True, local_res_path, ""
    except (ToolException, Exception) as e:
        err_key = "faild.fetch.event.log.export.destination"
        err_msg = common.getMsg(lang, err_key)
        logger.logError(str(e))
        return False, local_res_path, err_msg
