# -*- coding: UTF-8 -*-
import common
import config

class expandDiskInfo():
    """
    扩容硬盘配置类
    """
    def __init__(self):
        self.diskType = None          # 硬盘类型 例如:SSD、SAS
        self.diskCapacity = 0         # 硬盘容量 换算为以字节为单位
        self.diskNum = 0              # 硬盘数量  例如:{"SSD":10, "SAS":20}
        self.diskEngineId = None      # 引擎ID
        self.diskDomainId = None      # 硬盘域ID
        self.diskLogicEngId = None    #逻辑引擎ID
        self.originDiskCapacity = ""   # 原始硬盘容量
        self.originDiskUnit = "GB"   #原始硬盘容量单位GB，TB
    
    def setDiskType(self, diskType):
        self.diskType = diskType
    
    def getDiskType(self):
        return self.diskType
    
    def setDiskCapacity(self, diskCapacity):
        self.diskCapacity = diskCapacity
    
    def getDiskCapacity(self):
        return self.diskCapacity
    
    def setDiskNum(self, diskNum):
        self.diskNum = diskNum
        
    def getDiskNum(self):
        return self.diskNum
    
    def setDiskEngineId(self, diskEngineId):
        self.diskEngineId = diskEngineId
    
    def getDiskEngineId(self):
        return self.diskEngineId
    
    def setDiskDomainId(self, diskDomainId):
        self.diskDomainId = diskDomainId
    
    def getDiskDomainId(self):
        return self.diskDomainId
    
    def getDiskLogicEngId(self):
        return self.diskLogicEngId
    
    def setDiskLogicEngId(self,logicEng):
        self.diskLogicEngId = logicEng
        
    def getOriginDiskCapacity(self):
        return self.originDiskCapacity
    
    def setOriginDiskCapacity(self, originDiskCapacity):
        self.originDiskCapacity = originDiskCapacity
        
    def getOriginDiskUnit(self):
        return self.originDiskUnit
    
    def setOriginDiskUnit(self, originDiskUnit):
        self.originDiskUnit = originDiskUnit
    
class ExpandConfig():
    """
    扩容硬盘配置类
    """

    def __init__(self, py_java_env, according_logic_engine=False, logger=None):
        self.expDiskList = py_java_env.get("expDiskList")
        self.expDiskInfo = {}
        self.expDiskTypeOnDiskDomain = {}
        self.expDiskLevelOnDiskDomain = {}
        self.expDiskTypeOnEngine = {}
        self.expDiskTypeSet = set()
        self.expDiskCapacitySet = set()
        self.according_logic_engine = according_logic_engine
        self.support_logger = logger is not None
        self.logger = logger
    
    def logInfo(self, info_msg):
        if not self.support_logger:
            return
        self.logger.logInfo(info_msg)
    def getExpDiskTypeSet(self):
        for expDisk in self.expDiskList:
            self.expDiskTypeSet.add(expDisk.get("diskModel"))
            
        return self.expDiskTypeSet
    
    def getExpDiskCapacitySet(self):
        for expDisk in self.expDiskList:
            diskCapacity = expDisk.get("diskCapacity")
            unit = expDisk.get("unit")
            flag, diskCapacityGB = common.changUnit2GB(diskCapacity + unit, isLabelCap=True)
            if flag:
                self.expDiskCapacitySet.add(diskCapacityGB)
        
        return self.expDiskCapacitySet
        
    
    def getExpDiskInfo(self):
        expDiskList = filter(lambda x : x.get("diskDomain") != "none", self.expDiskList)
        for expDisk in expDiskList:
            diskType = expDisk.get("diskModel") #硬盘类型
            diskCapacity = expDisk.get("diskCapacity") #硬盘容量
            unit = expDisk.get("unit") #硬盘容量单位
            diskNum = int(expDisk.get("diskNum")) #硬盘数量
            diskEngineId = expDisk.get("eng")
            diskLogicEngId = expDisk.get("logicEng")
            diskDomainId = expDisk.get("diskDomain")
            expDiskInfoObj = expandDiskInfo()
            expDiskInfoObj.setDiskType(diskType)
            flag, diskCapacityGB = common.changUnit2GB(diskCapacity + unit, isLabelCap=True)
            if flag:
                expDiskInfoObj.setDiskCapacity(diskCapacityGB)
            expDiskInfoObj.setDiskNum(diskNum)
            expDiskInfoObj.setDiskEngineId(common.getEngineIdByDiskId(diskEngineId))
            expDiskInfoObj.setDiskDomainId(diskDomainId)
            expDiskInfoObj.setDiskLogicEngId(diskLogicEngId)
            expDiskInfoObj.setOriginDiskCapacity(diskCapacity)
            expDiskInfoObj.setOriginDiskUnit(unit)
            
            expDiskInfoList = []
            expDiskInfoList.append(expDiskInfoObj)
            self.expDiskInfo[diskDomainId] = self.expDiskInfo.get(diskDomainId, []) + expDiskInfoList
        
        return self.expDiskInfo
    
    def getExpDiskType(self):
        """
        获取硬盘域上新扩硬盘类型字典信息
        """
        expDiskList = filter(lambda x : x.get("diskDomain") != "none", self.expDiskList)
        for expDisk in expDiskList:
            diskTypeSet = set()
            diskDomainId = expDisk.get("diskDomain")
            diskTypeSet.add(expDisk.get("diskModel"))
            self.expDiskTypeOnDiskDomain[diskDomainId] = self.expDiskTypeOnDiskDomain.get(diskDomainId,
                                                                                          set()) | diskTypeSet
                
        return self.expDiskTypeOnDiskDomain

    def getExpDiskLevel(self):
        """
        获取硬盘域上新扩硬盘层级字典信息
        """
        expDiskList = filter(lambda x: x.get("diskDomain") != "none", self.expDiskList)
        for expDisk in self.expDiskList:
            diskLevelSet = set()
            diskDomainId = expDisk.get("diskDomain")
            diskLevelSet.add(config.DISK_TYPE_LEVEL_KEY.get(expDisk.get("diskModel")))
            self.expDiskLevelOnDiskDomain[diskDomainId] = self.expDiskLevelOnDiskDomain.get(diskDomainId,
                                                                                            set()) | diskLevelSet
        return self.expDiskLevelOnDiskDomain
    
    def getExpDiskTypeOnEngine(self):
        """
        获取引擎新扩容硬盘类型字典信息
        """
        expDiskList = filter(lambda x : x.get("diskDomain") != "none", self.expDiskList)
        for expDisk in expDiskList:
            diskTypeSet = set()
            engineId = common.getEngineIdByDiskId(expDisk.get("eng"))
            diskTypeSet.add(expDisk.get("diskModel"))
            self.expDiskTypeOnEngine[engineId] = self.expDiskTypeOnEngine.get(engineId, set()) | diskTypeSet
        
        return self.expDiskTypeOnEngine
    
    def getExpEngineDiskNumOnDD(self, diskDomainId):
        """
        获取指定硬盘域所在引擎的硬盘类型-数量字典信息,例如:{0:{"SSD":11, "SAS":6}, 1:{"SSD":17,"SAS":15,"SATA":8}}
        """
        expDiskInfoList = self.expDiskInfo.get(diskDomainId)
        expEngineDiskNumDic = {}
        for expDiskInfoObj in expDiskInfoList:
            engineId = expDiskInfoObj.getDiskLogicEngId()
            diskType = expDiskInfoObj.getDiskType()
            diskNum = expDiskInfoObj.getDiskNum()
            if engineId not in expEngineDiskNumDic:
                expEngineDiskNumDic[engineId] = dict()
            if not expEngineDiskNumDic.get(engineId).has_key(diskType):
                expEngineDiskNumDic[engineId][diskType] = diskNum
            else:
                expEngineDiskNumDic[engineId][diskType] += diskNum
        
        return expEngineDiskNumDic
    
    def getExpEngineDiskCapacityOnDD(self, diskDomainId):
        """
        获取指定硬盘域所在引擎的硬盘类型-容量字典信息,例如:
        {0: {'SAS': set([700]), 'SSD': set([521])}, 1:
        {'SAS': set([800, 500])}}
        """
        expDiskInfoList = self.expDiskInfo.get(diskDomainId)
        expEngineDiskCapacityDic = {}
        for expDiskInfoObj in expDiskInfoList:
            engineId = expDiskInfoObj.getDiskLogicEngId()
            diskType = expDiskInfoObj.getDiskType()
            diskCapacity = expDiskInfoObj.getDiskCapacity()
            if engineId not in expEngineDiskCapacityDic:
                expEngineDiskCapacityDic[engineId] = {}
            if not expEngineDiskCapacityDic.get(engineId).has_key(diskType):
                diskCapacitySets = set()
                diskCapacitySets.add(diskCapacity)
                expEngineDiskCapacityDic[engineId][diskType] = diskCapacitySets
            else:
                expEngineDiskCapacityDic[engineId][diskType].add(diskCapacity)
                
        return expEngineDiskCapacityDic
    
    
    def getAllExpDiskList(self):
        expDiskInfoList = []
        for expDisk in self.expDiskList:
            diskType = str(expDisk.get("diskModel"))  # 硬盘类型
            diskCapacity = expDisk.get("diskCapacity")  # 硬盘容量
            unit = expDisk.get("unit")  # 硬盘容量单位
            diskNum = int(expDisk.get("diskNum"))  # 硬盘数量
            diskEngineId = expDisk.get("eng")
            diskLogicEngId = expDisk.get("logicEng")
            diskDomainId = expDisk.get("diskDomain")
            expDiskInfoObj = expandDiskInfo()
            expDiskInfoObj.setDiskType(diskType)
            flag, diskCapacityGB = common.changUnit2GB(diskCapacity + unit, isLabelCap=True)
            if flag:
                expDiskInfoObj.setDiskCapacity(diskCapacityGB)
            expDiskInfoObj.setDiskNum(diskNum)
            expDiskInfoObj.setDiskEngineId(common.getEngineIdByDiskId(diskEngineId))
            expDiskInfoObj.setDiskDomainId(diskDomainId)
            expDiskInfoObj.setDiskLogicEngId(diskLogicEngId)
            expDiskInfoObj.setOriginDiskCapacity(diskCapacity)
            expDiskInfoObj.setOriginDiskUnit(unit)

            expDiskInfoList.append(expDiskInfoObj)
        return expDiskInfoList

    def get_total_disk_num_of_all_new_dd(self):
        """获取新建硬盘域的成员盘个数之和
        
        :return: 
        """
        new_dd_disk_list = filter(lambda x: x.get("diskDomain") == "none",
                               self.expDiskList)
        return sum(map(int, (dd.get('diskNum', 0) for dd in new_dd_disk_list)))

    def get_expansion_disk_num_per_engine(self):
        """获取各个引擎上新扩容硬盘个数：统计所有扩容已有的硬盘域的数据记录，
        按引擎相加。
        :return:
        """
        expansion_disk_num_per_engine = dict()
        for exp_disk in self.expDiskList:
            if exp_disk.get('diskDomain') == 'none':
                self.logInfo("newly created disk domain")
                continue

            self.logInfo("exp_disk eng:%s" % exp_disk.get('eng'))
            self.logInfo("exp_disk logicEng:%s" % exp_disk.get('logicEng'))

            pyhsic_engine_id_str = str(exp_disk.get('eng')[-1])
            logic_engine_id_str = str(exp_disk.get('logicEng'))
            if not all([pyhsic_engine_id_str, logic_engine_id_str]):
                self.logInfo('Data may be error.')
                continue

            if self.according_logic_engine:
                if logic_engine_id_str == "0":
                    engine_k = "{physic_engine_id}A/{physic_engine_id}B".\
                        format(physic_engine_id=pyhsic_engine_id_str)
                else:
                    engine_k = "{physic_engine_id}C/{physic_engine_id}D".\
                        format(physic_engine_id=pyhsic_engine_id_str)
            else:
                engine_k = "CTE{physic_engine_id}".format(
                    physic_engine_id=pyhsic_engine_id_str)
            self.logInfo("engine_k:%s" % engine_k)
            pre_cnt = expansion_disk_num_per_engine.get(engine_k, 0)
            expansion_disk_num_per_engine[engine_k] = pre_cnt + int(
                exp_disk.get("diskNum", 0)
            )
        return expansion_disk_num_per_engine
