#!/usr/bin/python
# -*- coding: UTF-8 -*-
import os
from memory_inspect.adapter.java_adapter import get_db_adapter


class Context(object):
    logger = None
    config = None
    lang = None


def get_connection():
    db_path = os.path.join(os.path.dirname(os.path.abspath(__file__)), "add_decoder_new.db")
    if not os.path.exists(db_path):
        raise ValueError("file not exit:{}\ncwd:{}".format(db_path, os.getcwd()))
    return get_db_adapter().get_connection(db_path)


conn = get_connection()


def select(sql_str):
    return get_db_adapter().fetch_one(conn, sql_str)
