#!/usr/bin/python
# -*- coding: UTF-8 -*-

from memory_inspect.address_decodes import connect
from memory_inspect.utils.six_about import to_hex_str, to_int


# 输入的系统地址 addr 为整形变量

def get_channel_address(addr, shift, socketWays, channelWays, tadChannelOffset):
    """求取 channel_address"""
    channel_addr = addr - to_int(tadChannelOffset)
    channel_addr = channel_addr >> shift
    channel_addr = channel_addr // (int(socketWays) * int(channelWays))
    channel_addr = channel_addr << shift

    mask = (2 ** shift) - 1
    low_bits = addr & mask
    channel_addr = (channel_addr | low_bits)

    return '0x{:012x}'.format(channel_addr)


def TAD_Base_2_16G_1P(addr, socket_id, imc_id, page_mode, numa_mode):
    shift = 8
    socketWays = 0
    channelWays = 0
    tadChannelOffset = 0

    if numa_mode == 'Disable':

        tad = ''  # 待求取

        for num in range(0, 2):
            base_temp = connect.select(
                "select _BASE, _LIMIT from PURPLE_TAD_1P where _CONFIG = '2_16G' "
                "and _INFO = '%s_%s' and _TAD = 'TAD%s'" % (
                    socket_id, imc_id, num))
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])
                tad_num = connect.select(
                    "select _TAD from PURPLE_TAD_1P where  _CONFIG = '2_16G' and _INFO = '%s_%s' and _BASE = '%s'" % (
                        socket_id, imc_id, to_hex_str(base)))
                tad = ''.join(tad_num)
        socketWays_temp = connect.select(
            "select _SOCKET_WAYS from PURPLE_TAD_1P where _CONFIG = '2_16G' and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        channelWays_tamp = connect.select(
            "select _CHANNEL_WAYs from PURPLE_TAD_1P where _CONFIG = '2_16G' and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        tadChannelOffset_temp = connect.select(
            "select _TAD_CHANNEL_OFFSET from PURPLE_TAD_1P where _CONFIG = '2_16G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        socketWays = ''.join(socketWays_temp)
        channelWays = ''.join(channelWays_tamp)
        tadChannelOffset = ''.join(tadChannelOffset_temp)

    if numa_mode == 'Enable':
        pass

    return get_channel_address(addr, shift, socketWays, channelWays, tadChannelOffset)


def TAD_Base_2_32G_1P(addr, socket_id, imc_id, page_mode, numa_mode):
    shift = 8
    socketWays = 0
    channelWays = 0
    tadChannelOffset = 0

    if numa_mode == 'Disable':

        tad = ''  # 待求取

        for num in range(0, 2):
            base_temp = connect.select(
                "select _BASE, _LIMIT from PURPLE_TAD_1P where _CONFIG = '2_32G' "
                "and _INFO = '%s_%s' and _TAD = 'TAD%s'" % (
                    socket_id, imc_id, num))
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])
                tad_num = connect.select(
                    "select _TAD from PURPLE_TAD_1P where  _CONFIG = '2_32G' "
                    "and _INFO = '%s_%s' and _BASE = '%s'" % (
                        socket_id, imc_id, to_hex_str(base)))
                tad = ''.join(tad_num)
        socketWays_temp = connect.select(
            "select _SOCKET_WAYS from PURPLE_TAD_1P where _CONFIG = '2_32G' and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        channelWays_tamp = connect.select(
            "select _CHANNEL_WAYs from PURPLE_TAD_1P where _CONFIG = '2_32G' and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        tadChannelOffset_temp = connect.select(
            "select _TAD_CHANNEL_OFFSET from PURPLE_TAD_1P where _CONFIG = '2_32G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        socketWays = ''.join(socketWays_temp)
        channelWays = ''.join(channelWays_tamp)
        tadChannelOffset = ''.join(tadChannelOffset_temp)

    if numa_mode == 'Enable':  # 4*32G socket不交织
        pass

    return get_channel_address(addr, shift, socketWays, channelWays, tadChannelOffset)


def TAD_Base_3_16G_1P(addr, socket_id, imc_id, page_mode, numa_mode):
    shift = 8
    socketWays = 0
    channelWays = 0
    tadChannelOffset = 0

    rang = 0

    if numa_mode == 'Disable':

        tad = ''  # 待求取
        if socket_id == 'SOCKET0' and imc_id == 'MC0':
            rang = 3
        if socket_id == 'SOCKET0' and imc_id == 'MC1':
            rang = 2

        for num in range(0, rang):
            base_temp = connect.select(
                "select _BASE, _LIMIT from PURPLE_TAD_1P where _CONFIG = '3_16G' "
                "and _INFO = '%s_%s' and _TAD = 'TAD%s'" % (
                    socket_id, imc_id, num))
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])
                tad_num = connect.select(
                    "select _TAD from PURPLE_TAD_1P where  _CONFIG = '3_16G' and _INFO = '%s_%s' and _BASE = '%s'" % (
                        socket_id, imc_id, to_hex_str(base)))
                tad = ''.join(tad_num)
        socketWays_temp = connect.select(
            "select _SOCKET_WAYS from PURPLE_TAD_1P where _CONFIG = '3_16G' and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        channelWays_tamp = connect.select(
            "select _CHANNEL_WAYs from PURPLE_TAD_1P where _CONFIG = '3_16G' and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        tadChannelOffset_temp = connect.select(
            "select _TAD_CHANNEL_OFFSET from PURPLE_TAD_1P where _CONFIG = '3_16G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        socketWays = ''.join(socketWays_temp)
        channelWays = ''.join(channelWays_tamp)
        tadChannelOffset = ''.join(tadChannelOffset_temp)

    if numa_mode == 'Enable':
        pass

    return get_channel_address(addr, shift, socketWays, channelWays, tadChannelOffset)


def TAD_Base_4_16G_1P(addr, socket_id, imc_id, page_mode, numa_mode):
    shift = 8
    socketWays = 0
    channelWays = 0
    tadChannelOffset = 0

    if numa_mode == 'Disable':

        tad = ''  # 待求取

        for num in range(0, 2):
            base_temp = connect.select(
                "select _BASE, _LIMIT from PURPLE_TAD_1P where _CONFIG = '4_16G' "
                "and _INFO = '%s_%s' and _TAD = 'TAD%s'" % (
                    socket_id, imc_id, num))
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])
                tad_num = connect.select(
                    "select _TAD from PURPLE_TAD_1P where  _CONFIG = '4_16G' and _INFO = '%s_%s' and _BASE = '%s'" % (
                        socket_id, imc_id, to_hex_str(base)))
                tad = ''.join(tad_num)
        socketWays_temp = connect.select(
            "select _SOCKET_WAYS from PURPLE_TAD_1P where _CONFIG = '4_16G' and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        channelWays_tamp = connect.select(
            "select _CHANNEL_WAYs from PURPLE_TAD_1P where _CONFIG = '4_16G' and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        tadChannelOffset_temp = connect.select(
            "select _TAD_CHANNEL_OFFSET from PURPLE_TAD_1P where _CONFIG = '4_16G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        socketWays = ''.join(socketWays_temp)
        channelWays = ''.join(channelWays_tamp)
        tadChannelOffset = ''.join(tadChannelOffset_temp)

    if numa_mode == 'Enable':
        pass

    return get_channel_address(addr, shift, socketWays, channelWays, tadChannelOffset)


def TAD_Base_4_32G_1P(addr, socket_id, imc_id, page_mode, numa_mode):
    shift = 8
    socketWays = 0
    channelWays = 0
    tadChannelOffset = 0

    if numa_mode == 'Disable':

        tad = ''  # 待求取

        for num in range(0, 2):
            base_temp = connect.select(
                "select _BASE, _LIMIT from PURPLE_TAD_1P where _CONFIG = '4_32G' "
                "and _INFO = '%s_%s' and _TAD = 'TAD%s'" % (
                    socket_id, imc_id, num))
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])
                tad_num = connect.select(
                    "select _TAD from PURPLE_TAD_1P where  _CONFIG = '4_32G' and _INFO = '%s_%s' and _BASE = '%s'" % (
                        socket_id, imc_id, to_hex_str(base)))
                tad = ''.join(tad_num)
        socketWays_temp = connect.select(
            "select _SOCKET_WAYS from PURPLE_TAD_1P where _CONFIG = '4_32G' and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        channelWays_tamp = connect.select(
            "select _CHANNEL_WAYs from PURPLE_TAD_1P where _CONFIG = '4_32G' and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        tadChannelOffset_temp = connect.select(
            "select _TAD_CHANNEL_OFFSET from PURPLE_TAD_1P where _CONFIG = '4_32G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        socketWays = ''.join(socketWays_temp)
        channelWays = ''.join(channelWays_tamp)
        tadChannelOffset = ''.join(tadChannelOffset_temp)

    if numa_mode == 'Enable':
        pass

    return get_channel_address(addr, shift, socketWays, channelWays, tadChannelOffset)


def TAD_Base_8_32G_1P(addr, socket_id, imc_id, page_mode, numa_mode):
    shift = 8
    socketWays = 0
    channelWays = 0
    tadChannelOffset = 0

    if numa_mode == 'Disable':

        tad = ''  # 待求取

        for num in range(0, 2):
            base_temp = connect.select(
                "select _BASE, _LIMIT from PURPLE_TAD_1P where _CONFIG = '8_32G' "
                "and _INFO = '%s_%s' and _TAD = 'TAD%s'" % (
                    socket_id, imc_id, num))
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])
                tad_num = connect.select(
                    "select _TAD from PURPLE_TAD_1P where  _CONFIG = '8_32G' and _INFO = '%s_%s' and _BASE = '%s'" % (
                        socket_id, imc_id, to_hex_str(base)))
                tad = ''.join(tad_num)
        socketWays_temp = connect.select(
            "select _SOCKET_WAYS from PURPLE_TAD_1P where _CONFIG = '8_32G' and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        channelWays_tamp = connect.select(
            "select _CHANNEL_WAYs from PURPLE_TAD_1P where _CONFIG = '8_32G' and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        tadChannelOffset_temp = connect.select(
            "select _TAD_CHANNEL_OFFSET from PURPLE_TAD_1P where _CONFIG = '8_32G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        socketWays = ''.join(socketWays_temp)
        channelWays = ''.join(channelWays_tamp)
        tadChannelOffset = ''.join(tadChannelOffset_temp)

    if numa_mode == 'Enable':
        pass

    return get_channel_address(addr, shift, socketWays, channelWays, tadChannelOffset)


def TAD_Base_4_32G_2P(addr, socket_id, imc_id, page_mode, numa_mode):
    shift = 8
    socketWays = 0
    channelWays = 0
    tadChannelOffset = 0

    if numa_mode == 'Disable':

        tad = ''  # 待求取

        for num in range(0, 2):
            base_temp = connect.select(
                "select _BASE, _LIMIT from PURPLE_TAD_2P where _CONFIG = '4_32G' "
                "and _INFO = '%s_%s' and _TAD = 'TAD%s'" % (
                    socket_id, imc_id, num))
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])
                tad_num = connect.select(
                    "select _TAD from PURPLE_TAD_2P where  _CONFIG = '4_32G' and _INFO = '%s_%s' and _BASE = '%s'" % (
                        socket_id, imc_id, to_hex_str(base)))
                tad = ''.join(tad_num)
        socketWays_temp = connect.select(
            "select _SOCKET_WAYS from PURPLE_TAD_2P where _CONFIG = '4_32G' and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        channelWays_tamp = connect.select(
            "select _CHANNEL_WAYs from PURPLE_TAD_2P where _CONFIG = '4_32G' and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        tadChannelOffset_temp = connect.select(
            "select _TAD_CHANNEL_OFFSET from PURPLE_TAD_2P where _CONFIG = '4_32G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        socketWays = ''.join(socketWays_temp)
        channelWays = ''.join(channelWays_tamp)
        tadChannelOffset = ''.join(tadChannelOffset_temp)

    if numa_mode == 'Enable':

        tad = ''  # 待求取

        for num in range(0, 2):
            base_temp = connect.select(
                "select _BASE, _LIMIT from PURPLE_TAD_2P where _CONFIG = 'NUMA_4_32G' "
                "and _INFO = '%s_%s' and _TAD = 'TAD%s'" % (
                    socket_id, imc_id, num))
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])
                tad_num = connect.select(
                    "select _TAD from PURPLE_TAD_2P where  _CONFIG = 'NUMA_4_32G' "
                    "and _INFO = '%s_%s' and _BASE = '%s'" % (
                        socket_id, imc_id, to_hex_str(base)))
                tad = ''.join(tad_num)
        socketWays_temp = connect.select(
            "select _SOCKET_WAYS from PURPLE_TAD_2P where _CONFIG = 'NUMA_4_32G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        channelWays_tamp = connect.select(
            "select _CHANNEL_WAYs from PURPLE_TAD_2P where _CONFIG = 'NUMA_4_32G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        tadChannelOffset_temp = connect.select(
            "select _TAD_CHANNEL_OFFSET from PURPLE_TAD_2P where _CONFIG = 'NUMA_4_32G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        socketWays = ''.join(socketWays_temp)
        channelWays = ''.join(channelWays_tamp)
        tadChannelOffset = ''.join(tadChannelOffset_temp)

    return get_channel_address(addr, shift, socketWays, channelWays, tadChannelOffset)


def TAD_Base_8_32G_2P(addr, socket_id, imc_id, page_mode, numa_mode):
    shift = 8
    socketWays = 0
    channelWays = 0
    tadChannelOffset = 0

    if numa_mode == 'Disable':

        tad = ''  # 待求取

        for num in range(0, 2):
            base_temp = connect.select(
                "select _BASE, _LIMIT from PURPLE_TAD_2P where _CONFIG = '8_32G' "
                "and _INFO = '%s_%s' and _TAD = 'TAD%s'" % (
                    socket_id, imc_id, num))
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])
                tad_num = connect.select(
                    "select _TAD from PURPLE_TAD_2P where  _CONFIG = '8_32G' and _INFO = '%s_%s' and _BASE = '%s'" % (
                        socket_id, imc_id, to_hex_str(base)))
                tad = ''.join(tad_num)
        socketWays_temp = connect.select(
            "select _SOCKET_WAYS from PURPLE_TAD_2P where _CONFIG = '8_32G' and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        channelWays_tamp = connect.select(
            "select _CHANNEL_WAYs from PURPLE_TAD_2P where _CONFIG = '8_32G' and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        tadChannelOffset_temp = connect.select(
            "select _TAD_CHANNEL_OFFSET from PURPLE_TAD_2P where _CONFIG = '8_32G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        socketWays = ''.join(socketWays_temp)
        channelWays = ''.join(channelWays_tamp)
        tadChannelOffset = ''.join(tadChannelOffset_temp)

    if numa_mode == 'Enable':

        tad = ''  # 待求取

        for num in range(0, 2):
            base_temp = connect.select(
                "select _BASE, _LIMIT from PURPLE_TAD_2P where _CONFIG = 'NUMA_8_32G' "
                "and _INFO = '%s_%s' and _TAD = 'TAD%s'" % (
                    socket_id, imc_id, num))
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])
                tad_num = connect.select(
                    "select _TAD from PURPLE_TAD_2P where  _CONFIG = 'NUMA_8_32G' "
                    "and _INFO = '%s_%s' and _BASE = '%s'" % (
                        socket_id, imc_id, to_hex_str(base)))
                tad = ''.join(tad_num)
        socketWays_temp = connect.select(
            "select _SOCKET_WAYS from PURPLE_TAD_2P where _CONFIG = 'NUMA_8_32G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        channelWays_tamp = connect.select(
            "select _CHANNEL_WAYs from PURPLE_TAD_2P where _CONFIG = 'NUMA_8_32G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        tadChannelOffset_temp = connect.select(
            "select _TAD_CHANNEL_OFFSET from PURPLE_TAD_2P where _CONFIG = 'NUMA_8_32G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        socketWays = ''.join(socketWays_temp)
        channelWays = ''.join(channelWays_tamp)
        tadChannelOffset = ''.join(tadChannelOffset_temp)

    return get_channel_address(addr, shift, socketWays, channelWays, tadChannelOffset)


def TAD_Base_16_32G_2P(addr, socket_id, imc_id, page_mode, numa_mode):
    shift = 8
    socketWays = 0
    channelWays = 0
    tadChannelOffset = 0

    if numa_mode == 'Disable':

        tad = ''  # 待求取

        for num in range(0, 2):
            base_temp = connect.select(
                "select _BASE, _LIMIT from PURPLE_TAD_2P where _CONFIG = '16_32G' "
                "and _INFO = '%s_%s' and _TAD = 'TAD%s'" % (
                    socket_id, imc_id, num))
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])
                tad_num = connect.select(
                    "select _TAD from PURPLE_TAD_2P where  _CONFIG = '16_32G' and _INFO = '%s_%s' and _BASE = '%s'" % (
                        socket_id, imc_id, to_hex_str(base)))
                tad = ''.join(tad_num)
        socketWays_temp = connect.select(
            "select _SOCKET_WAYS from PURPLE_TAD_2P where _CONFIG = '16_32G' and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        channelWays_tamp = connect.select(
            "select _CHANNEL_WAYs from PURPLE_TAD_2P where _CONFIG = '16_32G' and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        tadChannelOffset_temp = connect.select(
            "select _TAD_CHANNEL_OFFSET from PURPLE_TAD_2P where _CONFIG = '16_32G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        socketWays = ''.join(socketWays_temp)
        channelWays = ''.join(channelWays_tamp)
        tadChannelOffset = ''.join(tadChannelOffset_temp)

    if numa_mode == 'Enable':

        tad = ''  # 待求取

        for num in range(0, 2):
            base_temp = connect.select(
                "select _BASE, _LIMIT from PURPLE_TAD_2P where _CONFIG = 'NUMA_16_32G' "
                "and _INFO = '%s_%s' and _TAD = 'TAD%s'" % (
                    socket_id, imc_id, num))
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])
                tad_num = connect.select(
                    "select _TAD from PURPLE_TAD_2P where  _CONFIG = 'NUMA_16_32G' "
                    "and _INFO = '%s_%s' and _BASE = '%s'" % (
                        socket_id, imc_id, to_hex_str(base)))
                tad = ''.join(tad_num)
        socketWays_temp = connect.select(
            "select _SOCKET_WAYS from PURPLE_TAD_2P where _CONFIG = 'NUMA_16_32G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        channelWays_tamp = connect.select(
            "select _CHANNEL_WAYs from PURPLE_TAD_2P where _CONFIG = 'NUMA_16_32G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        tadChannelOffset_temp = connect.select(
            "select _TAD_CHANNEL_OFFSET from PURPLE_TAD_2P where _CONFIG = 'NUMA_16_32G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        socketWays = ''.join(socketWays_temp)
        channelWays = ''.join(channelWays_tamp)
        tadChannelOffset = ''.join(tadChannelOffset_temp)

    return get_channel_address(addr, shift, socketWays, channelWays, tadChannelOffset)


def TAD_Base_24_32G_2P(addr, socket_id, imc_id, page_mode, numa_mode):
    shift = 8
    socketWays = 0
    channelWays = 0
    tadChannelOffset = 0

    if numa_mode == 'Disable':

        tad = ''  # 待求取

        for num in range(0, 2):
            base_temp = connect.select(
                "select _BASE, _LIMIT from PURPLE_TAD_2P where _CONFIG = '24_32G' "
                "and _INFO = '%s_%s' and _TAD = 'TAD%s'" % (
                    socket_id, imc_id, num))
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])
                tad_num = connect.select(
                    "select _TAD from PURPLE_TAD_2P where  _CONFIG = '24_32G' "
                    "and _INFO = '%s_%s' and _BASE = '%s'" % (
                        socket_id, imc_id, to_hex_str(base)))
                tad = ''.join(tad_num)
        socketWays_temp = connect.select(
            "select _SOCKET_WAYS from PURPLE_TAD_2P where _CONFIG = '24_32G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        channelWays_tamp = connect.select(
            "select _CHANNEL_WAYs from PURPLE_TAD_2P where _CONFIG = '24_32G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        tadChannelOffset_temp = connect.select(
            "select _TAD_CHANNEL_OFFSET from PURPLE_TAD_2P where _CONFIG = '24_32G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        socketWays = ''.join(socketWays_temp)
        channelWays = ''.join(channelWays_tamp)
        tadChannelOffset = ''.join(tadChannelOffset_temp)

    if numa_mode == 'Enable':

        tad = ''  # 待求取

        for num in range(0, 2):
            base_temp = connect.select(
                "select _BASE, _LIMIT from PURPLE_TAD_2P where _CONFIG = 'NUMA_24_32G' "
                "and _INFO = '%s_%s' and _TAD = 'TAD%s'" % (
                    socket_id, imc_id, num))
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])
                tad_num = connect.select(
                    "select _TAD from PURPLE_TAD_2P where  _CONFIG = 'NUMA_24_32G' "
                    "and _INFO = '%s_%s' and _BASE = '%s'" % (
                        socket_id, imc_id, to_hex_str(base)))
                tad = ''.join(tad_num)
        socketWays_temp = connect.select(
            "select _SOCKET_WAYS from PURPLE_TAD_2P where _CONFIG = 'NUMA_24_32G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        channelWays_tamp = connect.select(
            "select _CHANNEL_WAYs from PURPLE_TAD_2P where _CONFIG = 'NUMA_24_32G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        tadChannelOffset_temp = connect.select(
            "select _TAD_CHANNEL_OFFSET from PURPLE_TAD_2P where _CONFIG = 'NUMA_24_32G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        socketWays = ''.join(socketWays_temp)
        channelWays = ''.join(channelWays_tamp)
        tadChannelOffset = ''.join(tadChannelOffset_temp)

    return get_channel_address(addr, shift, socketWays, channelWays, tadChannelOffset)


def TAD_Base_12_32G_2P(addr, socket_id, imc_id, page_mode, numa_mode):
    shift = 8
    socketWays = 0
    channelWays = 0
    tadChannelOffset = 0

    if numa_mode == 'Disable':

        tad = ''  # 待求取

        for num in range(0, 2):
            base_temp = connect.select(
                "select _BASE, _LIMIT from PURPLE_TAD_2P where _CONFIG = '12_32G' "
                "and _INFO = '%s_%s' and _TAD = 'TAD%s'" % (
                    socket_id, imc_id, num))
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])
                tad_num = connect.select(
                    "select _TAD from PURPLE_TAD_2P where  _CONFIG = '12_32G' "
                    "and _INFO = '%s_%s' and _BASE = '%s'" % (
                        socket_id, imc_id, to_hex_str(base)))
                tad = ''.join(tad_num)
        socketWays_temp = connect.select(
            "select _SOCKET_WAYS from PURPLE_TAD_2P where _CONFIG = '12_32G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        channelWays_tamp = connect.select(
            "select _CHANNEL_WAYs from PURPLE_TAD_2P where _CONFIG = '12_32G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        tadChannelOffset_temp = connect.select(
            "select _TAD_CHANNEL_OFFSET from PURPLE_TAD_2P where _CONFIG = '12_32G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        socketWays = ''.join(socketWays_temp)
        channelWays = ''.join(channelWays_tamp)
        tadChannelOffset = ''.join(tadChannelOffset_temp)

    if numa_mode == 'Enable':

        tad = ''  # 待求取

        for num in range(0, 2):
            base_temp = connect.select(
                "select _BASE, _LIMIT from PURPLE_TAD_2P where _CONFIG = 'NUMA_12_32G' "
                "and _INFO = '%s_%s' and _TAD = 'TAD%s'" % (
                    socket_id, imc_id, num))
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])
                tad_num = connect.select(
                    "select _TAD from PURPLE_TAD_2P where  _CONFIG = 'NUMA_12_32G' "
                    "and _INFO = '%s_%s' and _BASE = '%s'" % (
                        socket_id, imc_id, to_hex_str(base)))
                tad = ''.join(tad_num)
        socketWays_temp = connect.select(
            "select _SOCKET_WAYS from PURPLE_TAD_2P where _CONFIG = 'NUMA_12_32G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        channelWays_tamp = connect.select(
            "select _CHANNEL_WAYs from PURPLE_TAD_2P where _CONFIG = 'NUMA_12_32G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        tadChannelOffset_temp = connect.select(
            "select _TAD_CHANNEL_OFFSET from PURPLE_TAD_2P where _CONFIG = 'NUMA_12_32G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        socketWays = ''.join(socketWays_temp)
        channelWays = ''.join(channelWays_tamp)
        tadChannelOffset = ''.join(tadChannelOffset_temp)

    return get_channel_address(addr, shift, socketWays, channelWays, tadChannelOffset)


def TAD_Base_16_64G_2P(addr, socket_id, imc_id, page_mode, numa_mode):
    shift = 8
    socketWays = 0
    channelWays = 0
    tadChannelOffset = 0

    if numa_mode == 'Disable':

        tad = ''  # 待求取

        for num in range(0, 2):
            base_temp = connect.select(
                "select _BASE, _LIMIT from PURPLE_TAD_2P where _CONFIG = '16_64G' "
                "and _INFO = '%s_%s' and _TAD = 'TAD%s'" % (
                    socket_id, imc_id, num))
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])
                tad_num = connect.select(
                    "select _TAD from PURPLE_TAD_2P where  _CONFIG = '16_64G' "
                    "and _INFO = '%s_%s' and _BASE = '%s'" % (
                        socket_id, imc_id, to_hex_str(base)))
                tad = ''.join(tad_num)
        socketWays_temp = connect.select(
            "select _SOCKET_WAYS from PURPLE_TAD_2P where _CONFIG = '16_64G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        channelWays_tamp = connect.select(
            "select _CHANNEL_WAYs from PURPLE_TAD_2P where _CONFIG = '16_64G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        tadChannelOffset_temp = connect.select(
            "select _TAD_CHANNEL_OFFSET from PURPLE_TAD_2P where _CONFIG = '16_64G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        socketWays = ''.join(socketWays_temp)
        channelWays = ''.join(channelWays_tamp)
        tadChannelOffset = ''.join(tadChannelOffset_temp)

    if numa_mode == 'Enable':

        tad = ''  # 待求取

        for num in range(0, 2):
            base_temp = connect.select(
                "select _BASE, _LIMIT from PURPLE_TAD_2P where _CONFIG = 'NUMA_16_64G' "
                "and _INFO = '%s_%s' and _TAD = 'TAD%s'" % (
                    socket_id, imc_id, num))
            if to_int(base_temp[0]) <= addr <= to_int(base_temp[1]):
                base = to_int(base_temp[0])
                tad_num = connect.select(
                    "select _TAD from PURPLE_TAD_2P where  _CONFIG = 'NUMA_16_64G' "
                    "and _INFO = '%s_%s' and _BASE = '%s'" % (
                        socket_id, imc_id, to_hex_str(base)))
                tad = ''.join(tad_num)
        socketWays_temp = connect.select(
            "select _SOCKET_WAYS from PURPLE_TAD_2P where _CONFIG = 'NUMA_16_64G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        channelWays_tamp = connect.select(
            "select _CHANNEL_WAYs from PURPLE_TAD_2P where _CONFIG = 'NUMA_16_64G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        tadChannelOffset_temp = connect.select(
            "select _TAD_CHANNEL_OFFSET from PURPLE_TAD_2P where _CONFIG = 'NUMA_16_64G' "
            "and _INFO = '%s_%s' and _TAD = '%s'" % (
                socket_id, imc_id, tad))
        socketWays = ''.join(socketWays_temp)
        channelWays = ''.join(channelWays_tamp)
        tadChannelOffset = ''.join(tadChannelOffset_temp)

    return get_channel_address(addr, shift, socketWays, channelWays, tadChannelOffset)
