# coding: utf-8
# Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.
import re
import os


class LogResetParser(object):
    """
    log_reset日志解析，涉及文件路径：
    /OSM/coffer_log/log/his_debug/log_debug/his_tar_序列号_转储时间.tgz
    """
    def __init__(self, logger):
        self.logger = logger

    def parse(self, all_logs):
        all_result = []
        for ctrl, logs in all_logs.items():
            reset_logs = logs.get("reset", [])
            all_result.append("controller [{}] reset log records:".format(ctrl))
            one_ctrl_result = self.parse_one_ctrl(reset_logs)
            all_result.append(one_ctrl_result)
        return os.linesep.join(all_result)

    def parse_one_ctrl(self, file_paths):
        one_ctrl_result = list()
        # 1个控制器最多取5个文件分析就可以了，文件是按时间从老到新的顺序排列的
        for file_path in file_paths[-5:]:
            one_file_result = self.parse_one_file(file_path)
            one_ctrl_result.extend(one_file_result)
        sorted_result = sorted(one_ctrl_result, key=lambda x: x.get("time"), reverse=True)
        has_added_times = []
        show_records = []
        for result in sorted_result:
            if result.get("time") not in has_added_times:
                has_added_times.append(result.get("time"))
                show_records.append(result.get("records"))
            if len(show_records) >= 5:
                break
        return os.linesep.join(show_records)

    def parse_one_file(self, file_path):
        self.logger.info("begin to parse file={}".format(file_path))
        all_result = list()
        with open(file_path, 'r') as _log:
            for number, line in enumerate(_log):
                self._parse_err_info(line, all_result)

        self.logger.info("success parse: {}".format(file_path))
        return all_result

    @staticmethod
    def _parse_err_info(line, all_result):
        match_obj = re.search("localorcmostime=(\d+)", line)
        if match_obj:
            time = match_obj.group(1)
            all_result.append({"time": time, "records": line})
            return
        if all_result and "desktime" in line.lower():
            all_result[-1]["records"] += line
