# -*- coding: UTF-8 -*-
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""
    
    cliRet = cli.execCmd("showsystemp")
    list = cliRet.splitlines()
    if len(list) < 7:
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 2:
            continue
        elif list2[1] == "--":
            continue
        elif int(list2[1]) > 52:
            flag = False
            if "zh" == lang:
                errMsg += u"\n框" + list2[0] + u"的温度过高（" + list2[1] + u"℃）。"
            else:
                errMsg += "\nThe temperature(Celsius) of enclosure " \
                          + list2[0] + " is too high(" + list2[1] + ")."
        elif int(list2[1]) < 5:
            flag = False
            if "zh" == lang:
                errMsg += u"\n框" + list2[0] + u"的温度过低（" + list2[1] + u"℃）。"
            else:
                errMsg += "\nThe temperature(Celsius) of enclosure " \
                          + list2[0] + " is too low(" + list2[1] + ")."
                
    return (flag, cliRet, errMsg)