# -*- coding: UTF-8 -*-
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""
    
    cliRet = cli.execCmd("showfibremodule")
    list = cliRet.splitlines()
    if len(list) < 7:
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 9:
            continue
        if "Normal" not in list2:
            flag = False
            if "zh" == lang:
                errMsg += u"\n控制器" + list2[0] + u"上的框" + list2[1]\
                          + u"上的模块" + list2[4] + u"的端口" + list2[5]\
                          + u"的状态存在异常。"
            else:
                errMsg += "\nThe optical transceiver status of port " + list2[5]\
                          + " of module " + list2[4] + " of enclosure " + list2[1]\
                          +  " of controller " + list2[0] + " is abnormal."

    return (flag, cliRet, errMsg)