# -*- coding: UTF-8 -*-
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""
    usage = 0
    threadshold = 0

    cliRet = cli.execCmd("showrespool")
    list = cliRet.splitlines()
    if len(list) < 7:
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 3:
            continue
        if float(list2[1]) > 0.0:
            usage = int(float(list2[2]) / float(list2[1]) * 100)
            threadshold = int(list2[4])
            if usage >= threadshold:
                flag = False
                if "zh" == lang:
                    errMsg += u"\n资源池" + list2[0] + u"的使用率是" + str(usage)\
                              + u"%，超过了临界值" + str(threadshold) + u"%。"
                else:
                    errMsg += "\nThe usage(" + str(usage) + "%) of the resource pool " + list2[0]\
                              + " is larger than alarm threshold(" + str(threadshold) + "%)."

    return (flag, cliRet, errMsg)
