# -*- coding: UTF-8 -*-
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""
    
    cliRet = cli.execCmd("showprdsession")
    list = cliRet.splitlines()    
    if len(list) < 7:
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 7:
            continue
        if list2[6] not in ("Activated", "Normal"):
            flag = False
            if "zh" == lang:
                errMsg += u"\n定时快照" + list2[0] + u"的状态存在异常（" + list2[6] + u"）。"
            else:
                errMsg += "\nThe status of periodic snapshot at session " + list2[0]\
                          + " is abnormal(" + list2[6] + ")."

    return (flag, cliRet, errMsg)