# -*- coding: UTF-8 -*-
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""
    
    cliRet = cli.execCmd("showluncopy")
    list = cliRet.splitlines()
    if len(list) < 7:
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 5:
            continue
        if list2[4] != "Normal":
            flag = False
            if "zh" == lang:
                errMsg += u"\nLUN拷贝" + list2[1] + u"的状态存在异常（" + list2[4] + u"）。"
            else:
                errMsg += "\nThe status of LUN copy " + list2[1]\
                          + " is abnormal(" + list2[4] + ")."

    return (flag, cliRet, errMsg)