# -*- coding: UTF-8 -*-
"""P11G-5580 检查远程复制状态巡检项修改 20121204 modified Begin"""
import string

def execute(cli):
    """
    showrmtrep
    =================================================================================================
                                     Remote Replication Information
    -------------------------------------------------------------------------------------------------
      Name                    ID                  Mode            Is CG Member    Status    Role     
    -------------------------------------------------------------------------------------------------
      RemoteReplication001    0022A10B6C5C0000    Asynchronous    No              Normal    Primary  
    =================================================================================================
    """"""
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""
    healthstatustemp = ""
    
    cliRet = cli.execCmd("showrmtrep")
    list = cliRet.splitlines()
    if len(list) < 7:
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 5:
            continue
        if "Normal" != list2[4]:
            flag = False
            if "zh" == lang:
                errMsg += u"\n远程复制" + list2[1] + u"的状态存在异常（" + list2[4] + u"）。"
            else:
                errMsg += "\nThe status of remote replication " + list2[1]\
                          + " is abnormal(" + list2[4] + ")."
        rmtrepId = list2[1]
        iRet = checkRemoteReplication(cli, rmtrepId)
        #取得回显信息和健康状态
        cliRet += '\n\n' + iRet[1]
        healthstatustemp = iRet[2]
        #设置错误显示信息
        if False == iRet[0]:
            flag = False
            if "zh" == lang:
                errMsg += u"\n远程复制" + list2[1] + u"的健康状态存在异常（" + healthstatustemp + u"）。"
            else:
                errMsg += "\nThe health status of remote replication " + list2[1]\
                          + " is abnormal(" + healthstatustemp + ")."
    return (flag, cliRet, errMsg)


def checkRemoteReplication(cli, rmtrepId):
    
    """cli命令回显信息
    >showrmtrepmember -rep 0022A10B6C5C0000
    ===================================================================================
                              Remote Replication Information
    -----------------------------------------------------------------------------------
      ID                  LUN ID    Array SN                Relation    Health Status  
    -----------------------------------------------------------------------------------
      0022A10B6C5C0000    2         210235G6T8Z0C4000006    Primary     Normal         
    ==================================================================================="""
    #信息初始化
    flag = True
    healthstatus = ''
    
    cliRet = cli.execCmd("showrmtrepmember -rep " + str(rmtrepId))
    list = string.split(cliRet, '\n')
    
    """判断cli回显信息是否满足要求"""
    count = len(list)
    if count < 8:
        return(False, cliRet, '')

    """查询远程复制的健康状态"""
    healthstatus = (list[6].split())[4]
    
    if "Normal" != healthstatus:
        flag = False
    return(flag, cliRet, healthstatus)

"""P11G-5580 检查远程复制状态巡检项修改 20121204 modified End"""
