# -*- coding: UTF-8 -*-
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    controllerID = ""
    status = ""
    errMsg = ""
    
    cliRet = cli.execCmd("showexpmodule")
    list = cliRet.splitlines()
    for field in list:
        field = field.replace(" ", "").replace("|", "")
        if field.startswith("ControllerID"):
            controllerID = field.replace("ControllerID", "")
        elif field.startswith("Status"):
            status = field.replace("Status", "")
            if status != "Normal":
                flag = False
                if "zh" == lang:
                    errMsg += u"\n控制器" + controllerID + u"的扩展模块存在异常（" + status + u"）。"
                else:
                    errMsg += "\nThe status of expansion module of controller " \
                              + controllerID + " is abnormal(" + status + ")."
  
    return (flag, cliRet, errMsg)