# -*- coding: UTF-8 -*-
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""
    controllerID = ""
    operationStatus = ""
    healthStatus = ""
    
    cliRet = cli.execCmd("showcontroller")
    list = cliRet.splitlines()
    for field in list:
        field = field.replace(" ", "").replace("|", "")
        if field.startswith("ControllerID"):
            controllerID = field.replace("ControllerID", "")
        elif field.startswith("OperationStatus"):
            operationStatus = field.replace("OperationStatus", "")
            if "Normal" != operationStatus:
                flag = False
                if "zh" == lang:
                    errMsg += u"\n控制器" + controllerID + u"的操作状态存在异常（" + operationStatus + u"）。"
                else:
                    errMsg += "\nThe operation status of controller " + controllerID\
                              + " is abnormal(" + operationStatus + ")."
        elif field.startswith("HealthStatus"):
            healthStatus = field.replace("HealthStatus", "")
            if "Normal" != healthStatus:
                flag = False
                if "zh" == lang:
                    errMsg += u"\n控制器" + controllerID + u"的健康状态存在异常（" + healthStatus + u"）。"
                else:
                    errMsg += "\nThe health status of controller " + controllerID\
                              + " is abnormal(" + healthStatus + ")."
    return (flag, cliRet, errMsg)