# -*- coding: UTF-8 -*-

"""P11G-5580 框状态查询巡检项增加 20121204 added Begin"""
"""showenclosure
=========================================================================================================================
                                                  Enclosure Infomation
-------------------------------------------------------------------------------------------------------------------------
  Enclosure ID    Type          Status    Temperature(Celsius)    Physical Type    Serial Number           MAC Address   
-------------------------------------------------------------------------------------------------------------------------
  0               Controller    Online    32                      Common           210235G6EBZ0C1000007    303975683930  
  1               Expansion     Online    29                      FC               210235G6FPZ0B2000002    0022a104870e  
=========================================================================================================================

admin:/>
"""
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""
    
    cliRet = cli.execCmd("showenclosure")
    list = cliRet.splitlines()
    if len(list) < 9:
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 7:
            continue
        if "Online" != list2[2]:
            flag = False
            if "zh" == lang:
                errMsg += u"\n框" + list2[0] + u"的状态存在异常（" + list2[2] + u"）。"
            else:
                errMsg += "\nThe status of enclosure " + list2[0] \
                          + " is abnormal(" + list2[2] + ")."

    return (flag, cliRet, errMsg)

"""P11G-5580 框状态查询巡检项增加 20121204 added End"""
