# -*- coding: UTF-8 -*-
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    BBUID = ""
    BBUStatus = ""
    errMsg = ""
    
    cliRet = cli.execCmd("showbbu")
    list = cliRet.splitlines()
    for field in list:
        field = field.replace(" ", "").replace("|", "")
        
        if field.startswith("BBUID"):
            BBUID = field.replace("BBUID", "")
        elif field.startswith("Status"):
            BBUStatus = field.replace("Status", "")
            if BBUStatus != "Normal":
                flag = False
                if "zh" == lang:
                    errMsg += "\nBBU" + BBUID + u"的状态存在异常（" + BBUStatus + u"）。"
                else:
                    errMsg += "\nThe status of BBU " \
                              + BBUID + " is abnormal(" + BBUStatus + ")."

    return (flag, cliRet, errMsg)