# -*- coding: UTF-8 -*-
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""
    
    cliRet = cli.execCmd("showdisk -physic")
    list = cliRet.splitlines()
    if len(list) < 7:
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 2:
            continue
        if "Normal" != list2[1]:
            flag = False
            if "zh" == lang:
                errMsg += u"\n磁盘" + list2[0] + u"的物理状态存在异常（" + list2[1] + u"）。"
            else:
                errMsg += "\nThe physical status of disk " + list2[0] \
                          + " is abnormal(" + list2[1] + ")."

    return (flag, cliRet, errMsg)