# -*- coding: UTF-8 -*-
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : check Disk Logical Status 
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    import re

    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""
    
    #P11G-5709 重构完成的盘为异常 modified 20130218 Begin
    normalStatus = "Normal|Free spare|Used spare|Reconstruction is in progress|Copyback is in process"
    #P11G-5709 重构完成的盘为异常 modified 20130218 End
    normalStatus = re.compile(normalStatus)

    cliRet = cli.execCmd("showdisk -logic")
    list = cliRet.splitlines()
    if len(list) < 7:
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 2:
            continue
        if not re.search(normalStatus, field):
            flag = False
            if "zh" == lang:
                errMsg += u"\n磁盘" + list2[0] + u"的逻辑状态存在异常（" + list2[1] + u"）。"
            else:
                errMsg += "\nThe logical status of disk " + list2[0] \
                          + " is abnormal(" + list2[1] + ")."

    return (flag, cliRet, errMsg)