# -*- coding: UTF-8 -*-
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""

    cliRet = cli.execCmd("showsys")
    list = cliRet.splitlines()
    for field in list:
        if field.startswith("  Current System Mode"):
            if "Normal" not in field:
                flag = False
                if "zh" == lang:
                    errMsg += u"\n系统运行存在异常（" + field[field.index("|") + 2:].strip() + u"）。"
                else:
                    errMsg += "\nThe system runs abnormally(" + field[field.index("|") + 2:].strip()\
                              + ")."

    return (flag, cliRet, errMsg)