﻿# -*- coding: UTF-8 -*-

import re
import xlrd
import os

"""由于Python库xlrd的局限性，目前只支持解析Excel_2003的文件"""
COMPASS_DISK_FILE_NAME = r'compass_Huawei.xls'
COMPASS_DISK_FILDOR= r'CompassDiskCheck'

"""保险箱盘容量差值(23GB或者24GB)"""
VAULT_DISK_CAPACITY_GAP_MIN = 23
VAULT_DISK_CAPACITY_GAP_MAX = 24

class Excel(object):

# **************************************************************************** #
# 函数名称:  __init__
# 功    能:    初始化类，初始化获取文件路径
# 输入参数:  filename 文件名
# 输出参数:  无
# 返回值  :   NA
# 其 他   :    无
#**************************************************************************#
    def __init__(self, filename = COMPASS_DISK_FILE_NAME):
        """将当前路径插入到文件名前"""
        filepath = py_java_env.get("path")
        filename = filepath + os.sep+filename
        self.filename = filename
# **************************************************************************** #
# 函数名称: open
# 功能说明: 打开excel文件
# 输入参数:  NA
# 输出参数:  NA
# 返回值  :  NA
# 其 他   :  无
#**************************************************************************#   
    def open(self):
        self.dada = xlrd.open_workbook(self.filename)
# **************************************************************************** #
# 函数名称: creatCompassDiskList
# 功能说明: 通过excel文档，生成Compass盘的列表
# 输入参数:  sheet_name 工作簿名称
#            start_row  开始行数
# 输出参数:  无
# 返回值  :  NA
# 其 他   :  无
#**************************************************************************#    
    def creatCompassDiskList(self, sheet_name, start_row):
        
        self.table = self.dada.sheet_by_name(sheet_name)
        nrows = self.table.nrows
        seriesNoList = []

        for rownum in range(start_row, nrows, 1):
            cell=str(self.table.cell(rownum, 0))

            if bool(re.search('empty', cell, re.IGNORECASE)):
                continue
            elif bool(re.search('DRIVE_SERIAL_NUM', cell, re.IGNORECASE)):
                continue
            else:
                driveSeriesNo = cell.replace('text:u', '').replace('\'', '')
                seriesNoList.append(driveSeriesNo)

        return seriesNoList   

# **************************************************************************** #
# 函数名称: getDiskList
# 功能说明: 解析excel的入口函数
# 输入参数:  NA
# 输出参数:  无
# 返回值  :  （seriesNoList设备compass风险盘列表）
# 其 他   :  无
#**************************************************************************#   
def getDiskList():

    excel=Excel()
    excel.open()
    seriesNoList = excel.creatCompassDiskList('Affected SN',0)

    return(seriesNoList)


# **************************************************************************** #
# 函数名称: createDiskClassifyDict
# 功能说明: 根据当前设备磁盘信息，创建磁盘分类字典
# 输入参数: allDiskLogicInfoDict
# 输出参数: NA
# 返 回 值:  currentDiskSortDict（磁盘分类汇总字典）
# 其 他   :  无
# **************************************************************************** #   
def createDiskClassifyDict(allDiskLogicInfoDict):

    currentDiskSortDict = {}    #当前设备磁盘分类字典
    freeVaultDiskList = []      #空闲保险箱盘list
    freeNotVaultDiskList = []   #空闲盘（非保险箱盘）list
    freeSpareNotVaultDiskList = []  #空闲热备盘（非保险箱盘）list
    memberNotVaultDiskList = []     #其他各成员盘(非保险箱盘)list
    memberVaultDiskList = []    #其他各成员盘(保险箱盘)list

    """循环判断逻辑信息查询"""
    for key in allDiskLogicInfoDict:
        logicDiskInfo = allDiskLogicInfoDict[key]
        
        vaultDiskFlag = logicDiskInfo['Vaultflag']
        diskLogicStatus = logicDiskInfo['Status']
        diskLogicType = logicDiskInfo['Type']

        
        """创建空闲保险箱盘list"""
        if vaultDiskFlag == True and diskLogicType == 'Free':
            freeVaultDiskList.append(key)
            continue
        
        """创建空闲（非保险箱盘）list"""
        if vaultDiskFlag == False and diskLogicType == 'Free':
            freeNotVaultDiskList.append(key)
            continue
        
        """创建空闲热备盘（非保险箱盘）list"""
        if vaultDiskFlag == False and diskLogicStatus == 'Free spare':
            freeSpareNotVaultDiskList.append(key)
            continue
        
        """其他Member（非保险箱盘）盘"""
        if vaultDiskFlag == False and diskLogicType == 'Member':
            memberNotVaultDiskList.append(key)
            continue
        
        """其他Member（保险箱盘）盘"""
        if vaultDiskFlag == True and diskLogicType == 'Member':
            memberVaultDiskList.append(key)
            continue
        
    """将查询后的list保存入字典"""
    currentDiskSortDict['freeVault'] = freeVaultDiskList
    currentDiskSortDict['freeNotVault'] = freeNotVaultDiskList
    currentDiskSortDict['freeSpareNotVault'] = freeSpareNotVaultDiskList
    currentDiskSortDict['memberNotVault'] = memberNotVaultDiskList
    currentDiskSortDict['memberVault'] = memberVaultDiskList
    
    return currentDiskSortDict

# **************************************************************************** #
# 函数名称: setLogicInfoIfVaultDisk
# 功能说明: 遍历磁盘，根据磁盘的容量差值来判断是否是保险箱盘，取相应的保险箱盘信息
# 输入参数: allDiskPhysicInfoDict, allDiskLogicInfoDict
# 输出参数: NA
# 返 回 值:  vaultDiskLogicInfo(取保险箱盘信息 )
# 其 他   :  无
# **************************************************************************** #                                  
def setLogicInfoIfVaultDisk(allDiskPhysicInfoDict, allDiskLogicInfoDict):
    
    """初始化数据结构"""
    vaultDiskCounter = 0                                         # 保险箱盘个数
    vaultDiskLogicInfo = {}                                      # 保险箱盘信息
 
    physicDiskInfo = {'Location': '', 'Capacity': 0}             # 物理磁盘信息
    logicDiskInfo = {'Location': '', 'Status': '', 'Type': '', 'Capacity': 0, 'Vaultflag': False}  # 逻辑磁盘信息


    """根据磁盘的容量差值来判断"""
    for key in allDiskPhysicInfoDict:
        physicDiskInfo = allDiskPhysicInfoDict[key]
        logicDiskInfo = allDiskLogicInfoDict[key]
        
        """保险箱盘:物理容量-逻辑容量，差值为23GB或者24GB"""
        capacityGap = int(int(physicDiskInfo['Capacity']) - int(logicDiskInfo['Capacity']))
        
        if capacityGap in [VAULT_DISK_CAPACITY_GAP_MIN, VAULT_DISK_CAPACITY_GAP_MAX]:
            logicDiskInfo['Vaultflag'] = True
            vaultDiskCounter += 1
        
        vaultDiskLogicInfo[key] = logicDiskInfo

    #P12V-2488 风险盘检查处理优化  modified 20130225 Begin
    """检查保险箱盘个数大于4，则执行错误 """
    if vaultDiskCounter > 4:
        return (False, {})
    #P12V-2488 风险盘检查处理优化  modified 20130225 End

    return (True, vaultDiskLogicInfo)


# **************************************************************************** #
# 函数名称: getCurrentDiskSortDict
# 功能说明: 获取设备当前所有磁盘的分类字典
# 输入参数: allDiskPhyInfo, allDiskLogInfo
# 输出参数: NA
# 返 回 值:  vaultDiskLogicInfo(取保险箱盘信息 )
# 其 他   :  无
# **************************************************************************** # 
def getCurrentDiskSortDict(allDiskPhyInfo, allDiskLogInfo):
  
    """所有磁盘物理状态信息字典：{'（0,0）’：{'Location': '', 'Capacity': 0}}"""
    allDiskPhysicInfoDict = {}
    """所有磁盘逻辑状态信息字典：{'（0,0）’：{'Location': '', 'Status': '', 'Type': '', 'Capacity': 0}, 'Vaultflag': False}"""
    allDiskLogicInfoDict = {}
    """排序后的磁盘字典结构"""
    currentDiskSortDict = {'freeVault': [], 'freeNotVault': [], 'freeSpareNotVault': [], 'memberNotVault': [] ,'memberVault': []}

 
    """解析盘的物理信息"""
    diskInfoPhyList = allDiskPhyInfo.splitlines()
    for diskInfo in diskInfoPhyList[6:]:
        """初始化数据结构"""
        physicDiskInfo = {'Location': '', 'Capacity': 0}
        field = diskInfo.split()
        if len(field) < 8:
            break
        
        diskLocation = field[0]
        iRet = getDiskPhysicDetailInfo(diskInfo)
        diskCapacity = iRet[0]
        
        """数据存入字典"""
        physicDiskInfo['Location'] = diskLocation
        physicDiskInfo['Capacity'] = diskCapacity
        allDiskPhysicInfoDict[diskLocation] = physicDiskInfo
    
    
    """解析盘的逻辑信息"""
    diskInfoLogList = allDiskLogInfo.splitlines()
    for diskInfo in diskInfoLogList[6:]:
        """初始化数据结构"""
        logicDiskInfo = {'Location': '', 'Status': '', 'Type': '', 'Capacity': 0, 'Vaultflag': False}
        field = diskInfo.split()
        if len(field) < 4:
            break

        """获取磁盘逻辑信息"""
        diskDetail = getDiskLogicDetailInfo(diskInfo)
        
        diskLocation = diskDetail[0]
        diskLogStatus = diskDetail[1]
        diskLogType = diskDetail[2]
        diskCapacity = diskDetail[3]      

        """数据存入字典"""
        logicDiskInfo['Location'] = diskLocation
        logicDiskInfo['Status'] = diskLogStatus
        logicDiskInfo['Type'] = diskLogType
        logicDiskInfo['Capacity'] = diskCapacity
        allDiskLogicInfoDict[diskLocation] = logicDiskInfo
        
    
    """设置所有磁盘逻辑信息中的保险箱盘flag"""
    iRet = setLogicInfoIfVaultDisk(allDiskPhysicInfoDict, allDiskLogicInfoDict)
    if True == iRet[0]:
        """更新所有盘逻辑信息"""
        allDiskLogicInfoDict = iRet[1]
    else:
        return (False, {})

    """创建设备磁盘排序后字典数据"""
    currentDiskSortDict = createDiskClassifyDict(allDiskLogicInfoDict)
    
    return (True,currentDiskSortDict)
    

# **************************************************************************** #
# 函数名称: riskDiskListSort
# 功能说明: 获取设备希捷compass风险盘检查结果
# 输入参数：allDiskPhyInfo  设备所有物理磁盘信息
#          allDiskLogInfo   设备所有逻辑磁盘信息
#          riskDiskList     设备所有风险盘列表       
# 输出参数: NA
# 返 回 值:  （True Or False巡检结果，CliRet，riskDiskSortRet返回风险盘检查结果） 
# 其 他   :  无
# **************************************************************************** # 
def riskDiskListSort(allDiskPhyInfo, allDiskLogInfo, riskDiskList):

    """初始化数据结构"""
    currentDiskSortDict = {}
    
    freeVaultRiskDiskListStr = ''
    freeNotVaultRiskDiskListStr = ''
    freeSpareNotVaultRiskDiskListStr = ''
    memberNotVaultRiskDiskListStr = ''
    memberVaultRiskDiskListStr = ''
    
    freeVaultRiskDiskCounter = 0
    freeNotVaultRiskDiskCounter = 0
    freeSpareNotVaultRiskDiskCounter = 0
    memberNotVaultRiskDiskCounter = 0
    memberVaultRiskDiskCounter = 0
    
    checkDesc = ''
    
    lang = py_java_env.get("lang")

    cliRet = allDiskPhyInfo + '\n' + allDiskLogInfo
        
    """获取设备当前所有磁盘的分类字典"""
    iRet = getCurrentDiskSortDict(allDiskPhyInfo, allDiskLogInfo)
    if False == iRet[0]:
        if lang == 'zh':
            checkDesc = u'检查失败'
        else:
            checkDesc = 'check python error'
        return (False, cliRet, checkDesc)
    else:
        currentDiskSortDict = iRet[1]
    
    """提取相关list信息"""
    tempfreeVaultDiskList = currentDiskSortDict['freeVault']
    tempfreeNotVaultDiskList = currentDiskSortDict['freeNotVault']
    tempfreeSpareNotVaultDiskList = currentDiskSortDict['freeSpareNotVault']
    tempmemberNotVaultDiskList = currentDiskSortDict['memberNotVault']
    tempmemberVaultDiskList = currentDiskSortDict['memberVault']
    
    """生成风险盘检查列表"""
    for diskLocation in riskDiskList:
        locationTmp = ''
        
        #非Raid组成员盘的保险箱盘            
        if diskLocation in tempfreeVaultDiskList:
            if freeVaultRiskDiskCounter != 0:
                locationTmp = ',' + diskLocation
            else:
                locationTmp = diskLocation
            freeVaultRiskDiskListStr += locationTmp
            freeVaultRiskDiskCounter += 1     
             
        #非保险箱的空闲盘   
        elif diskLocation in tempfreeNotVaultDiskList:
            if freeNotVaultRiskDiskCounter != 0:
                locationTmp = ',' + diskLocation
            else:
                locationTmp = diskLocation
            freeNotVaultRiskDiskListStr += locationTmp
            freeNotVaultRiskDiskCounter += 1
        
        #空闲热备盘
        elif diskLocation in tempfreeSpareNotVaultDiskList:
            if freeSpareNotVaultRiskDiskCounter != 0:
                locationTmp = ',' + diskLocation
            else:
                locationTmp = diskLocation
            freeSpareNotVaultRiskDiskListStr += locationTmp
            freeSpareNotVaultRiskDiskCounter += 1

        
        #Raid组中非保险箱槽位的成员盘
        elif diskLocation in tempmemberNotVaultDiskList:
            if memberNotVaultRiskDiskCounter != 0:
                locationTmp = ',' + diskLocation
            else:
                locationTmp = diskLocation
            memberNotVaultRiskDiskListStr += locationTmp
            memberNotVaultRiskDiskCounter += 1
        
        #Raid组中成员盘的保险箱盘
        elif diskLocation in tempmemberVaultDiskList:
            if memberVaultRiskDiskCounter != 0:
                locationTmp = ',' + diskLocation
            else:
                locationTmp = diskLocation
            memberVaultRiskDiskListStr += locationTmp
            memberVaultRiskDiskCounter += 1 
        else:
            continue


    """风险盘检查结果返回"""
    if lang == 'zh':
        riskDiskSortRet = u'\n请先巡检设备，所有巡检项通过后，再严格按照换盘指导书的要求依次更换以下compass盘:\n'
    else:
        riskDiskSortRet = '\nAfter all inspection items are passed, replace the following compass disks in sequence as follows according to the instructions in the guide :\n'
    
    stepCounter = 0
    if freeVaultRiskDiskCounter != 0:
        stepCounter += 1
        if lang == 'zh':
            riskDiskSortRet += u'步骤' + str(stepCounter) + u'、依次更换非Raid组成员盘的保险箱盘 ：' + freeVaultRiskDiskListStr + '\n'
        else:
            if freeVaultRiskDiskCounter == 1:
                riskDiskSortRet += 'Step' + str(stepCounter) + '. Replace free coffer disk:' + freeVaultRiskDiskListStr + '\n'            
            else:
                riskDiskSortRet += 'Step' + str(stepCounter) + '. Replace free coffer disks:' + freeVaultRiskDiskListStr + '\n'            
    
    if freeNotVaultRiskDiskCounter != 0:
        stepCounter += 1
        if lang == 'zh':
            riskDiskSortRet += u'步骤' + str(stepCounter) + u'、依次更换非保险箱盘的空闲盘 ：' + freeNotVaultRiskDiskListStr + '\n'
        else:
            if freeNotVaultRiskDiskCounter == 1:
                riskDiskSortRet += 'Step' + str(stepCounter) + '. Replace free disk that is not coffer disk:' + freeNotVaultRiskDiskListStr + '\n'
            else:
                riskDiskSortRet += 'Step' + str(stepCounter) + '. Replace free disks that are not coffer disks:' + freeNotVaultRiskDiskListStr + '\n'
                
    if freeSpareNotVaultRiskDiskCounter != 0:
        stepCounter += 1
        #P12V-2441 空闲热备盘描述修改 modified 20130216 Begin 
        if lang == 'zh':
            riskDiskSortRet += u'步骤' + str(stepCounter) + u'、依次更换空闲热备盘 ：' + freeSpareNotVaultRiskDiskListStr + '\n'
        else:
            if freeSpareNotVaultRiskDiskCounter == 1:
                riskDiskSortRet += u'Step' + str(stepCounter) + u'. Replace free hot spare disk:' + freeSpareNotVaultRiskDiskListStr + '\n'
            else:
                riskDiskSortRet += u'Step' + str(stepCounter) + u'. Replace free hot spare disks:' + freeSpareNotVaultRiskDiskListStr + '\n'
        #P12V-2441 空闲热备盘描述修改 modified 20130216 End
       
    if memberNotVaultRiskDiskCounter != 0:
        stepCounter += 1
        if lang == 'zh':
            riskDiskSortRet += u'步骤' + str(stepCounter) + u'、依次更换Raid组中非保险箱槽位的成员盘 ：' + memberNotVaultRiskDiskListStr + '\n'
        else:
            if memberNotVaultRiskDiskCounter == 1:
                riskDiskSortRet += 'Step' + str(stepCounter) + '. Replace RAID group\'s member disk that is not coffer disk:' + memberNotVaultRiskDiskListStr + '\n'
            else:
                riskDiskSortRet += 'Step' + str(stepCounter) + '. Replace RAID group\'s member disks that are not coffer disks:' + memberNotVaultRiskDiskListStr + '\n'
   
    if memberVaultRiskDiskCounter != 0:
        stepCounter += 1
        if lang == 'zh':
            riskDiskSortRet += u'步骤' + str(stepCounter) + u'、依次更换Raid组中成员盘的保险箱盘 ：' + memberVaultRiskDiskListStr + '\n'
        else:
            if memberVaultRiskDiskCounter == 1:
                riskDiskSortRet += u'Step' + str(stepCounter) + u'. Replace RAID group\'s member disk that is coffer disk:' + memberVaultRiskDiskListStr + '\n'
            else:
                riskDiskSortRet += u'Step' + str(stepCounter) + u'. Replace RAID group\'s member disks that are coffer disks:' + memberVaultRiskDiskListStr + '\n'

    return (False, cliRet, riskDiskSortRet)

# **************************************************************************** #
# 函数名称: getDiskLogicDetailInfo
# 功能说明: 通过CLI信息取得磁盘的逻辑信息
# 输入参数： diskLogicInfo   设备逻辑磁盘信息 
# 输出参数: NA
# 返 回 值: （logicLocation框号、槽位号，logicStatus逻辑状态，logicType逻辑类型，logicCapacity逻辑容量） 
# 其 他   :  无
# **************************************************************************** # 
def getDiskLogicDetailInfo(diskLogicInfo):
    
    logicLocation = ''
    logicStatus = ''
    logicType = ''
    logicCapacity = ''

    field = diskLogicInfo.split()
    
    logicLocation = field[0]

    """获取磁盘逻辑status:重构中"""
    if re.search('Reconstruction is in progress', diskLogicInfo, re.IGNORECASE):
        logicStatus = 'Reconstruction is in progress'
        
        if re.search('SmartCache Member', diskLogicInfo, re.IGNORECASE):
            logicType = 'Member'
            logicCapacity = field[7]
        else:
            logicType = field[5]
            logicCapacity = field[6]
            
        return (logicLocation, logicStatus, logicType, logicCapacity)
            
    """获取磁盘逻辑status:空闲热备盘"""
    if re.search('Free spare', diskLogicInfo, re.IGNORECASE):
        logicStatus = 'Free spare'
        
        if re.search('SmartCache Member', diskLogicInfo, re.IGNORECASE):
            logicType = 'Member'
            logicCapacity = field[5]
        else:
            logicType = field[3]
            logicCapacity = field[4]

        return (logicLocation, logicStatus, logicType, logicCapacity)

    """获取磁盘逻辑status:已使用热备盘"""
    if re.search('Used spare', diskLogicInfo, re.IGNORECASE):
        logicStatus = 'Used spare'
        
        if re.search('SmartCache Member', diskLogicInfo, re.IGNORECASE):
            logicType = 'SmartCache Member'
            logicCapacity = field[5]
        else:
            logicType = field[3]
            logicCapacity = field[4]
    
        return (logicLocation, logicStatus, logicType, logicCapacity)

    """获取磁盘逻辑status:回拷中"""
    if re.search('Copyback is in process', diskLogicInfo, re.IGNORECASE):
        logicStatus = 'Copyback is in process'
        
        if re.search('SmartCache Member', diskLogicInfo, re.IGNORECASE):
            logicType = 'Member'
            logicCapacity = field[7]
        else:
            logicType = field[5]
            logicCapacity = field[6]
            
        return (logicLocation, logicStatus, logicType, logicCapacity)
     
    logicStatus = field[1]

    #P12V-2488 风险盘检查处理优化  modified 20130225 Begin
    if re.search('SmartCache Member', diskLogicInfo, re.IGNORECASE):
        logicType = 'Member'
        logicCapacity = field[4]
    else:
        logicType = field[2]
        logicCapacity = field[3]
    #P12V-2488 风险盘检查处理优化  modified 20130225 End
    
    return (logicLocation, logicStatus, logicType, logicCapacity)     

#P12V-2488 风险盘检查处理优化  modified 20130225 Begin
# **************************************************************************** #
# 函数名称: getDiskPhysicDetailInfo
# 功能说明: 通过CLI信息取得磁盘的物理信息
# 输入参数： diskPhysicInfo   设备物理磁盘信息 
# 输出参数: NA
# 返 回 值: （physicCapacity物理磁盘容量，physicSerialNum物理磁盘SN号） 
# 其 他   :  无
# **************************************************************************** # 
def getDiskPhysicDetailInfo(diskPhysicInfo):

    physicCapacity = ''
    physicSerialNum = ''

    field = diskPhysicInfo.split()
    capacityIndex = 9
    serialNumIndex = 5
    
    """获取磁盘物理Type:NL SAS"""
    if re.search('NL SAS', diskPhysicInfo, re.IGNORECASE):
        capacityIndex += 1
        serialNumIndex += 1

    """获取磁盘物理Status"""
    if re.search('Off line', diskPhysicInfo, re.IGNORECASE):
        capacityIndex += 1
        serialNumIndex += 1
    elif re.search('Single path', diskPhysicInfo, re.IGNORECASE):
        capacityIndex += 1
        serialNumIndex += 1     
    elif re.search('Write protect', diskPhysicInfo, re.IGNORECASE):
        capacityIndex += 1
        serialNumIndex += 1

    physicCapacity = field[capacityIndex]
    physicSerialNum = field[serialNumIndex]
            
    return (physicCapacity, physicSerialNum)
#P12V-2488 风险盘检查处理优化  modified 20130225 End

#P12V-2442 磁盘状态异常处理优化 added 20130216 Begin
# **************************************************************************** #
# 函数名称: checkPhysicDiskProcess
# 功能说明: 判断是否存在物理状态异常的磁盘
# 输入参数： (diskPhysicInfo:设备物理磁盘信息, lang:工具的语言环境 )
# 输出参数: NA
# 返 回 值: （True/False:检查结果，checkDesc：检查详细信息） 
# 其 他   :  无
# **************************************************************************** # 
def checkPhysicDiskProcess(allDiskPhyInfoList, lang):
    
    """初始化变量"""
    checkDesc = ''
    diskPhyinfo = ''
    phyAbnormalDisksInfo = ''
    diskLocation = ''
    phyAbnormalFlag = False
    diskCounter = 0

    """判断物理状态：是否存在非Normal的盘"""
    for diskPhyinfo in allDiskPhyInfoList[6:]:
        
        phyAbnormalFlag = False
        field = diskPhyinfo.split()

        #P12V-2488 风险盘检查处理优化  modified 20130225 Begin
        if len(field) > 2:
            diskLocation = field[0]
            diskPhysicalStatus = field[1]
            
            if diskPhysicalStatus != 'Normal':
                phyAbnormalFlag = True
            else:
                continue
        else:
            break
        #P12V-2488 风险盘检查处理优化  modified 20130225 End
            
        if phyAbnormalFlag == True:
            diskCounter += 1

            if phyAbnormalDisksInfo == '':
                phyAbnormalDisksInfo += diskLocation
            else:
                phyAbnormalDisksInfo += ',' + diskLocation
    
    """判断是否存在状态异常的盘"""
    if phyAbnormalDisksInfo == '':
        return (True, '')
    
    if lang == 'zh':
        checkDesc = u'系统中磁盘' + phyAbnormalDisksInfo + u'物理状态存在异常，请使用巡检工具检查修复后，再重新检查。'
    else:
        if diskCounter > 1:
            checkDesc = 'Disks' + phyAbnormalDisksInfo + 'in the storage system have physical fault, please use the inspection tool to check and repair them then perform a check again.'
        else:
            checkDesc = 'Disk' + phyAbnormalDisksInfo + 'in the storage system has physical fault, please use the inspection tool to check and repair it then perform a check again.'
    
    return (False, checkDesc)
    
# **************************************************************************** #
# 函数名称: checkLogicDiskProcess
# 功能说明: 判断是否存在逻辑状态异常的磁盘
# 输入参数：(allDiskLogInfoList:设备逻辑磁盘信息, lang:工具的语言环境 )
# 输出参数: NA
# 返 回 值: （True/False:检查结果，checkDesc：检查详细信息）  
# 其 他   :  无
# **************************************************************************** # 
def checkLogicDiskProcess(allDiskLogInfoList, lang):
    
    """初始化变量"""
    checkDesc = ''
    diskLoginfo = ''
    diskLocation = ''
    logDiskCheckFlag = True
    
    diskInReconstructionInfo = ''
    diskInCopybackInfo = ''
    diskReconstructedInfo = ''
    diskFaultInfo = ''
    #P12V-2441 增加预拷贝状态处理 added 20130216 Begin
    diskPrecopyingInfo = ''
    #P12V-2441 增加预拷贝状态处理 added 20130216 End
    diskInvalidInfo = ''
    
    diskInReconstructionCounter = 0
    diskInCopybackCounter = 0
    diskReconstructedCounter = 0
    diskFaultCounter = 0
    #P12V-2441 增加预拷贝状态处理 added 20130216 Begin
    diskPrecopyingCounter = 0
    #P12V-2441 增加预拷贝状态处理 added 20130216 End
    diskInvalidCounter = 0

    """判断逻辑状态：是否存在非Normal的盘"""
    for diskLoginfo in allDiskLogInfoList[6:]:
        
        #P12V-2488 风险盘检查处理优化  modified 20130225 Begin
        field = diskLoginfo.split()
        if len(field) < 2:
            break
        elif len(field) < 4:
            diskLocation = field[0]
            diskInvalidCounter += 1
            logDiskCheckFlag = False
            
            if diskInvalidInfo == '':
                diskInvalidInfo += diskLocation
            else:
                diskInvalidInfo += ',' + diskLocation
            
            continue             
        else:
            diskLocation = field[0]
        #P12V-2488 风险盘检查处理优化  modified 20130225 End
                
        diskLogicDetail = getDiskLogicDetailInfo(diskLoginfo)

        if diskLogicDetail[1] in ['Normal', 'Free spare', 'Used spare']:
            continue
        
        elif diskLogicDetail[1] == 'Reconstruction is in progress':
            diskInReconstructionCounter += 1
            logDiskCheckFlag = False
            if diskInReconstructionInfo == '':
                diskInReconstructionInfo += diskLocation
            else:
                diskInReconstructionInfo += ',' + diskLocation
        
        elif diskLogicDetail[1] == 'Copyback is in process':
            diskInCopybackCounter += 1
            logDiskCheckFlag = False
            if diskInCopybackInfo == '':
                diskInCopybackInfo += diskLocation
            else:
                diskInCopybackInfo += ',' + diskLocation            

        elif diskLogicDetail[1] == 'Reconstructed':
            diskReconstructedCounter += 1
            logDiskCheckFlag = False
            if diskReconstructedInfo == '':
                diskReconstructedInfo += diskLocation
            else:
                diskReconstructedInfo += ',' + diskLocation

        elif diskLogicDetail[1] == 'Fault':
            diskFaultCounter += 1
            logDiskCheckFlag = False
            if diskFaultInfo == '':
                diskFaultInfo += diskLocation
            else:
                diskFaultInfo += ',' + diskLocation             

        #P12V-2441 增加预拷贝状态处理 added 20130216 Begin
        elif diskLogicDetail[1] == 'Precopying':
            diskPrecopyingCounter += 1
            logDiskCheckFlag = False
            if diskPrecopyingInfo == '':
                diskPrecopyingInfo += diskLocation
            else:
                diskPrecopyingInfo += ',' + diskLocation            
        #P12V-2441 增加预拷贝状态处理 added 20130216 End

        else:
            diskInvalidCounter += 1
            logDiskCheckFlag = False
            if diskInvalidInfo == '':
                diskInvalidInfo += diskLocation
            else:
                diskInvalidInfo += ',' + diskLocation  
            
        
    """设置检查返回信息"""
    if diskInReconstructionInfo != '':
        if lang == 'zh':
            checkDesc += u'系统中磁盘' + diskInReconstructionInfo + u'正在重构，请等待磁盘重构完成后再检查。' + '\n'
        else:
            if diskInReconstructionCounter > 1:
                checkDesc += 'Disks' + diskInReconstructionInfo + 'in storage system are being reconstructed. Wait until all the disks reconstruction is completed and then perform a check.' + '\n'
            else:
                checkDesc += 'Disk' + diskInReconstructionInfo + 'in storage system is being reconstructed. Wait until the reconstruction is completed and then perform a check.' + '\n'

    if diskInCopybackInfo != '':
        if lang == 'zh':
            checkDesc += u'系统中磁盘' + diskInCopybackInfo + u'正在回拷，请等待磁盘回拷完成后再检查。' + '\n'
        else:
            if diskInCopybackCounter > 1:
                checkDesc += 'Disks' + diskInCopybackInfo + 'in storage system are in copyback process. Wait until all the disks copyback process is completed and then perform a check.' + '\n'
            else:
                checkDesc += 'Disk' + diskInCopybackInfo + 'in storage system is in copyback process. Wait until the copyback process is completed and then perform a check.' + '\n'
            
    if diskReconstructedInfo != '':
        if lang == 'zh':
            checkDesc += u'系统中磁盘' + diskReconstructedInfo + u'重构完成，请修复后再检查。' + '\n'
        else:
            if diskReconstructedCounter > 1:
                checkDesc += 'Disks' + diskReconstructedInfo + 'in storage system that have been reconstructed. Please repair them and then perform a check.' + '\n'
            else:
                checkDesc += 'Disk' + diskReconstructedInfo + 'in storage system that has been reconstructed. Please repair it and then perform a check.' + '\n'

    if diskFaultInfo != '':
        if lang == 'zh':
            checkDesc += u'系统中磁盘' + diskFaultInfo + u'为故障盘，请更换后再检查。' + '\n'
        else:
            if diskFaultCounter > 1:
                checkDesc += 'Disks' + diskFaultInfo + 'in storage system are faulty, replace them and then perform a check.' + '\n'
            else:
                checkDesc += 'Disk' + diskFaultInfo + 'in storage system is faulty, replace it and then perform a check.' + '\n'
    
    #P12V-2441 增加预拷贝状态处理 added 20130216 Begin        
    if diskPrecopyingInfo != '':
        if lang == 'zh':
            checkDesc += u'系统中磁盘' + diskPrecopyingInfo + u'正在预拷贝，请等待预拷贝完成后再检查。' + '\n'
        else:
            if diskPrecopyingCounter > 1:
                checkDesc += 'Disks' + diskPrecopyingInfo + 'in storage system are in precopying process. Wait until all the disks precopying process is completed and then perform a check.' + '\n'
            else:
                checkDesc += 'Disk' + diskPrecopyingInfo + 'in storage system is in precopying process. Wait until the precopying process is completed and then perform a check.' + '\n'
    #P12V-2441 增加预拷贝状态处理 added 20130216 End

    if diskInvalidInfo != '':
        if lang == 'zh':
            checkDesc += u'系统中磁盘' + diskInvalidInfo + u'逻辑状态存在异常，请修复后再检查。' + '\n'
        else:
            if diskInvalidCounter > 1:
                checkDesc += 'The logic status of disks' + diskInvalidInfo + 'in storage system are abnormal. Please repair them and then perform a check.' + '\n'
            else:
                checkDesc += 'The logic status of disk' + diskInvalidInfo + 'in storage system is abnormal. Please repair it and then perform a check.' + '\n'

    return (logDiskCheckFlag, checkDesc) 
  
#P12V-2442 磁盘状态异常处理优化 added 20130216 End

#P12V-2442 磁盘状态异常处理优化 modified 20130216 Begin
# **************************************************************************** #
# 函数名称: execute
# 功能说明: 工具调用此方法执行Compass风险盘检查
# 输入参数： ssh   工具与设备的ssh连接 
# 输出参数: NA
# 返 回 值: （True/False:检查结果，cliRet：cli回显信息， checkDesc：检查详细信息） 
# 其 他   :  无
# **************************************************************************** # 
def execute(ssh):
    
    """初始化变量信息"""
    riskDiskList = []
    riskDiskCounter = 0
    cliRet = ''
    checkDesc = ''
    
    lang = py_java_env.get("lang")

    """工具取得风险盘的序列号list"""
    seriesNumList = getDiskList()
    
    #P12V-2488 风险盘检查处理优化  added 20130225 Begin
    iRet = ssh.execCmd('chgpagination off')
    #P12V-2488 风险盘检查处理优化  added 20130225 End
    
    """查询磁盘的逻辑信息+物理信息"""
    allDiskPhyInfo = ssh.execCmd('showdisk -physic')
    allDiskLogInfo = ssh.execCmd('showdisk -logic')
    
    cliRet = allDiskPhyInfo + '\n' + allDiskLogInfo

    """判断cli回显信息"""
    if not re.search('Disk Information', allDiskPhyInfo, re.IGNORECASE):
        if lang == 'zh':
            checkDesc = u'cli回显信息错误'
        else:
            checkDesc = 'cli information error'
        return (False, cliRet, checkDesc)
    
    allDiskPhyInfoList = allDiskPhyInfo.splitlines()
    if len(allDiskPhyInfoList) < 4:
        if lang == 'zh':
            checkDesc = u'cli回显信息错误'
        else:
            checkDesc = 'cli information error'
        return (False, cliRet, checkDesc)
    
    if not re.search('Disk Information', allDiskLogInfo, re.IGNORECASE):
        if lang == 'zh':
            checkDesc = u'cli回显信息错误'
        else:
            checkDesc = 'cli information error'
        return (False, cliRet, checkDesc)
    
    allDiskLogInfoList = allDiskLogInfo.splitlines()
    if len(allDiskLogInfoList) < 4:
        if lang == 'zh':
            checkDesc = u'cli回显信息错误'
        else:
            checkDesc = 'cli information error'
        return (False, cliRet, checkDesc)

	#P11G-5853存在故障盘时列举出compass风险盘 modified 20130517 Begin	
    riskdiskPrint = ""
    """磁盘物理信息：检查指定盘是否在风险盘列表中"""
    for diskPhyInfo in allDiskPhyInfoList[6:]:
        
        field = diskPhyInfo.split()
        if len(field) < 8 :
		    continue
			
        diskLocation = field[0]

        iRet = getDiskPhysicDetailInfo(diskPhyInfo)
        diskSerialNum = iRet[1]
        searchSerialNum = diskSerialNum[0:8]
        
        if searchSerialNum in seriesNumList:            
            riskDiskList.append(diskLocation)
            riskDiskCounter += 1
            
            if riskDiskCounter == 1:
                riskdiskPrint += diskLocation
            else:     
                riskdiskPrint += ',' + diskLocation
            
    """判断所有盘物理状态：是否存在非Normal的盘"""
    iRet = checkPhysicDiskProcess(allDiskPhyInfoList, lang)
    if False == iRet[0]:
        checkDesc = iRet[1]
        
        #存在风险盘，则需要增加风险盘显示
        if riskDiskCounter != 0:
            if lang == 'zh':
                    checkDesc += u'\n同时，系统中存在需要更换的风险盘：' + riskdiskPrint + u'。'
            else:
                if riskDiskCounter == 1:    
                    checkDesc += u'\nMoreover, compass disk as follow:' + riskdiskPrint + '.'
                else:
                    checkDesc += u'\nMoreover, compass disks as follow:' + riskdiskPrint + '.'
                            
        return (False, cliRet, checkDesc)
            
    """判断所有盘逻辑状态：是否存在非Normal的盘"""
    iRet = checkLogicDiskProcess(allDiskLogInfoList, lang)
    if False == iRet[0]:
        checkDesc = iRet[1]
        
        #存在风险盘，则需要增加风险盘显示
        if riskDiskCounter != 0:
            if lang == 'zh':
                    checkDesc += u'同时，系统中存在需要更换的风险盘：' + riskdiskPrint + u'。'
            else:
                if riskDiskCounter == 1:    
                    checkDesc += u'Moreover, compass disk as follow:' + riskdiskPrint + '.'
                else:
                    checkDesc += u'Moreover, compass disks as follow:' + riskdiskPrint + '.'   
                
        return (False, cliRet, checkDesc)
    #P11G-5853存在故障盘时列举出compass风险盘 modified 20130517 End

    #不存在风险盘和故障盘，直接返回
    if riskDiskCounter == 0:
        if lang == 'zh':
            checkDesc = u'检查完成，不存在需要更换的风险盘。'
        else:
            checkDesc = 'Completed Checking, The storage system does not contain compass disk has a failure risk.'
        return (True, cliRet, checkDesc)
    
    """对风险盘列表进行排序"""
    iRet = riskDiskListSort(allDiskPhyInfo, allDiskLogInfo, riskDiskList)
    
    return iRet

#P12V-2442 磁盘状态异常处理优化 modified 20130216 End
