# -*- coding: UTF-8 -*-
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""

    cliRet = cli.execCmd("showlun")
    list = cliRet.splitlines()
    if len(list) < 7:
        return (flag, cliRet, errMsg)

    for field in list[6:]:
            list2 = field.split()
            if len(list2) < 4:
                continue
            if list2[3] not in ("Normal", "Formatting"):
                flag = False
                if "zh" == lang:
                    errMsg += u"\nRAID组" + list2[1] + u"的" + list2[6] + u"的状态存在异常（" + list2[3] + u"）。"
                else:
                    errMsg += "\nThe status of " + list2[6] + " of RAID group " + list2[1]\
                              + " is abnormal(" + list2[3] + ")."

    return (flag, cliRet, errMsg)