# -*- coding: UTF-8 -*-
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""    
    poolID = ""
    total = 0.0
    consumed = 0.0
    avail = 0.0

    cliRet = cli.execCmd("showsmtcpool")
    list = cliRet.splitlines()
    for field in list:
        field = field.replace(" ", "").replace("|", "")
        
        if field.startswith("SmartCachePoolID"):
            poolID = field.replace("SmartCachePoolID", "")
        elif field.startswith("TotalCapacity(MB)"):
            total = float(field.replace("TotalCapacity(MB)", ""))
        elif field.startswith("ConsumedCapacity(MB)"):
            consumed = float(field.replace("ConsumedCapacity(MB)", ""))
        elif field.startswith("AvailableCapacity(MB)"):
            avail = float(field.replace("AvailableCapacity(MB)", ""))
            if total != (consumed + avail):
                flag = False
                if "zh" == lang:
                    errMsg += u"\n智能缓存池" + poolID + u"的总容量（" + str(total) + u"MB）不等于可用容量（"\
                              + str(avail) + u"MB）和使用容量（" + str(avail) + u"MB）之和。"
                else:
                    errMsg += "\nTotal capacity (" + str(total) + "MB) of smart cache pool " + poolID\
                              + " is not equal to the sum of available capacity ("\
                              + str(avail) + "MB) and consumed capacity (" + str(consumed) + "MB)."

    return (flag, cliRet, errMsg)
