# -*- coding: UTF-8 -*-
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    import re
    
    flag = True
    lang = py_java_env.get("lang")
    password = py_java_env.get('devPwd').get('developer')
    errMsg = ""

    cli.execCmdWithTimout("developer", 2)
    cli.execCmdWithTimout("y", 2)
    cli.execCmdNoLogTimout(password, 2)
    cliRet = cli.execCmd("showswan")

    # 只有R5版本才有此命令，非R5版本直接返回“成功”，并在原始信息栏给出提示。
    if re.search("Command : \"showswan\" not exist.", cliRet):
        if "zh" == lang:
            cliRet = u"当前版本不支持此操作。"
        else:
            cliRet = "The command \"showswan\" is not supported."
        cli.execCmdWithTimout("exit", 2)
        return (flag, cliRet, errMsg)
    
    list = cliRet.splitlines()
    for field in list:
        field = field.replace(" ", "").replace("|", "")
        
        if field.startswith("Status"):
            status = field.replace("Status", "")
            if "Running" != status:
                flag = False
                if "zh" == lang:
                    errMsg += u"\nSmartWAN的状态存在异常（" + status + u"）。"
                else:
                    errMsg += "\nThe status of SmartWAN is abnormal(" + status + ")."
    
    cli.execCmdWithTimout("exit", 2)
    return (flag, cliRet, errMsg)