# -*- coding: UTF-8 -*-
from java.io import File
from java.lang import Exception
from cbb.frame.util.tar_util import decompress_tar_all_file
import os
import re
import string

#P12V-2951 未恢复告警检查项优化 modified 20130807 Begin
# **************************************************************************** #
# 函数名称: switchValidVersion
# 功能说明: 将版本号转化成有效的版本号（17位：V100R002C00SPC001 或者11位：V100R005C02）
# 输入参数: version
# **************************************************************************** # 
def switchValidVersion(version):
    temp = ""
    
    startIndex = version.index("V100")
    if re.search("SPC", version, re.IGNORECASE):
        endIndex = startIndex + 17
    else:
        endIndex = startIndex + 11
    
    #提取有效的版本号信息
    temp = version[startIndex: endIndex]
    
    return temp

# **************************************************************************** #
# 函数名称: getDeviceSpcVersion
# 功能说明: 获取热补丁的SPC版本号
# 输入参数: cli
# **************************************************************************** #
def getDeviceSpcVersion(cli): 

    ctrlSpc = cli.execCmd('showupgradepkginfo -t 1')
    rowList = string.split(ctrlSpc, '\n')
    count = len(rowList)
    devVersion = ''
    for i in range(count):
        if bool(re.search('Controller ID', rowList[i], re.IGNORECASE)):
            columnList = string.split(rowList[i + 2])
            #P12I-3845 特殊版本号优化处理  modified 20130806 Begin
            devVersion = switchValidVersion(columnList[1])
            break
            #P12I-3845 特殊版本号优化处理  modified 20130806 End

    return (devVersion, ctrlSpc)
#P12V-2951 未恢复告警检查项优化 modified 20130807 End

# **************************************************************************** #
# 函数名称: decompressPKG
# 功能说明: 解压告警文件
# 输入参数: filePath，depressPath
# **************************************************************************** #
def decompressPKG(filePath, depressPath):
    decompress_tar_all_file(filePath, depressPath)

# **************************************************************************** #
# 函数名称: getPath
# 功能说明: 获取告警文件路径
# 输入参数: strRet
# **************************************************************************** #
def getPath(strRet):
    strs = strRet.splitlines()    
    for str in strs:
        if str.startswith("Path :"):
            return str.replace("Path :", "").replace(" ", "")            
    return ""

# **************************************************************************** #
# 函数名称: execute
# 功能说明: 脚本执行接口
# 输入参数: cli
# **************************************************************************** #
def execute(cli):

    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""

    #P12V-2951 未恢复告警检查项优化 modified 20130807 Begin
    #工具传入的SFTP为空，检查失败
    cliRet = ""
    sftp = py_java_env.get("sftp")
    if sftp is None:
        if "zh" == lang:
            errMsg = u"工具传入SFTP为空，检查失败，请通过登录ISM查看是否存在未恢复告警。"
        else:
            errMsg = "The sftp provided by tool is None, check failed, please check the unrecovered alarm by ISM."
        return (False, cliRet, errMsg)
    
    #特殊的系统版本，工具不支持检查
    iRet = getDeviceSpcVersion(cli)
    spcVersion = iRet[0]
    cliRet = iRet[1]
    if spcVersion == "" or spcVersion in ["V100R002C00SPC010", "V100R002C01SPC007"]:
        flag = False
        if "zh" == lang:
            errMsg = u"\n当前设备的系统版本过低，不能够完全支持巡检工具的告警检查。" \
                                          + u"\n（1）请直接通过登录ISM查看确认系统是否存在未恢复告警；" \
                                            + u"\n（2）建议升级到最新的发布版本；"
        else:
            errMsg = "\nCurrent system version of device is too low, and can not totally support to check the unrecovered alarm by the inspector." \
                                          + "\n(1) Please check the unrecovered alarm by ISM;" \
                                            + "\n(2) You are suggestted to upgrade the device to the up-to-date released version."
        return (flag, cliRet, errMsg)        

    cliRet = cli.execCmd("exportsysevent -t alarm")
    #Cli回文异常，直接返回不通过
    if not bool(re.search("Path", cliRet, re.IGNORECASE)):
        flag = False
        if "zh" == lang:
            errMsg = u"\n通过CLI命令生成告警文件失败，请通过登录ISM查看是否存在未恢复告警。"
        else:
            errMsg = "\nRunning cli command to creat alarm file failed, please check the unrecovered alarm by ISM."
        return (flag, cliRet, errMsg)
    
    remoteFile = getPath(str(cliRet))
    localFile = File('tmp' + os.sep + 'event_export.tar')
    #P12V-2951 未恢复告警检查项优化 modified 20130807 End
    
    try:
        sftp.getFile(remoteFile, localFile, None)
    except Exception:
        if "zh" == lang:
            errMsg += u"\n告警文件" + remoteFile + u"不存在。"
        else:
            errMsg += "\nAlarm file " + remoteFile + " does not exist."
        return (False, errMsg, errMsg)
    
    decompressPKG('tmp' + os.sep + 'event_export.tar', "tmp")
    alarmFile = open('tmp' + os.sep + 'local_alm_file.txt', "r")
    alarmIDs = []
    cliRet = "Raised  Local Time    Alarm ID    Alarm Level    Recovered Local Time    Description\n"
    for line in alarmFile:
        if line.find("Event list") >= 0:
            break
        
        list = line.split()
        if len(list) < 5:
            continue
        if list[4] != "None":
            continue
        if list[3] not in ("Major", "Critical", "Warning"):
            continue
        
        flag = False
        # 将Suggestion字段之前的字符串添加到原始信息cliRet中。
        index = line.find("Step 1")
        cliRet += line[0:index]
        cliRet += "\n"

        alarmIDs.append(list[2])
    alarmFile.close()
    
    if not flag:
        if "zh" == lang:
            errMsg += u"\n存在未恢复告警，告警ID列表：" + str(alarmIDs).replace("[", "").replace("]", "") + u"。"
        else:
            errMsg += "\nThere are unrecovered alarms: " + str(alarmIDs).replace("[", "").replace("]", "")\
                      + "."
    
    return (flag, cliRet, errMsg)