# -*- coding: UTF-8 -*-
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""
    mirrorlist = []

    cliRet = cli.execCmd("showmirror")
    list = cliRet.splitlines()
    if len(list) < 7:
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 2:
            continue
        mirrorlist.append(list2[1])

    for mirrorid in mirrorlist:
        cliRet2 = cli.execCmd("showsecluninmirror -mirror " + mirrorid)
        cliRet += cliRet2
        list3 = cliRet2.splitlines()
        if len(list3) < 7:
            continue
    
        for field2 in list3[6:]:
            list4 = field2.split()
            if len(list4) < 4:
                continue
            if list4[3] in ("Interrupted", "Fault", "Toberecovered"):
                flag = False
                if "zh" == lang:
                    errMsg += u"\n分裂镜像" + mirrorid + u"的Pair" + list4[2] + u"存在异常。"
                else:
                    errMsg += "\nThe status of pair " + list4[2] + " of mirror "\
                              + mirrorid + " is abnormal(" + list4[3] + ")."
                              
    return (flag, cliRet, errMsg)