# -*- coding: UTF-8 -*-
def execute(cli):
    """
    Function name      : execute(cli)
    Function describe  : 检查系统所有的版本信息，包括SYS包版本信息、冷补丁包版本信息和热补丁包版本信息。
    Input              : cli  CLI通道
    Return             : flag：          检查项是否通过：True，通过。False，不通过
	                     versionInfos：  所有的版本信息
						 errMsg：        巡检不通过的详细描述
    """

    # 1, 2, 3分别代表SYS包、冷补丁包和热补丁包
    pkgTypes = [1, 2, 3]
    versionInfos = '''\
========================================================
             Package Version Information
--------------------------------------------------------
  Controller ID    Package Type       Package Version
--------------------------------------------------------'''
    cliRet = ""
    version = ""
    
    for pkgType in pkgTypes:
        # 构造查询版本命令
        cmd = "showupgradepkginfo -t " + str(pkgType)
        cliRet = cli.execCmd(cmd)
        lines = cliRet.splitlines()
        
        # 命令执行结果小于7行，说明执行该命令后并没有输出有效信息
        if len(lines) < 7:
            continue
        
        # 从第7行开始，取出有效信息
        for line in lines[6:]:
            fields = line.split()
            if len(fields) < 3:
                break
            # 只取出正在运行的版本号
            if "Running" == fields[2]:
                # 处理S2600T特殊的版本号
                version = fields[1].replace("S2600T", "")
                # 构造版本信息字符串
                versionInfos += ("\n  %-17s%-19s%-s" % (fields[0], str(pkgType), version))
                
    versionInfos += "\n========================================================"
    
    # 只查询版本号，检查项总是成功，失败信息总为空
    return (True, versionInfos, "")