﻿# -*- coding: UTF-8 -*-

"""P11G-5580 Lun负载均衡巡检项增加 20121204 added Begin"""
import re
import string

"""查询Lun负载均衡状态"""
def execute(cli):
    """"cli命令回显信息
    showlun
    =========================================================================================================================================
                                                LUN Information
    -----------------------------------------------------------------------------------------------------------------------------------------
      ID    RAID Group ID    Disk Pool ID    Status    Controller    Visible Capacity(MB)    LUN Name      Stripe Unit Size(KB)    Lun Type  
    -----------------------------------------------------------------------------------------------------------------------------------------
      0     0                --              Normal    A             57344.0                 LUN001        64                      FAT       
      1     0                --              Normal    B             57344.0                 LUN002        64                      FAT       
      2     1                --              Normal    A             96256.0                 LUN003_001    64                      FAT       
    =========================================================================================================================================
    
    admin:/>"""
    
    tempOwnController = ""
    tempWorkController = ""
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""

    cliRet = cli.execCmd("showlun")
    list = cliRet.splitlines()
    """判断cli回显信息是否满足要求"""
    if len(list) < 9:
        return (True, cliRet, errMsg)
        
    """lun负载均衡巡检项CLI回显过长 20130830 added Begin"""
    unbalancedNum = 0
    
    for field in list[6:]:
        
        luninfo = field.split()
        if len(luninfo) < 9:
            continue
        else:
            lunId = luninfo[0]
            #查询每一个Lun的负载均衡信息
            iRet = checklunloadbalance(cli, lunId)
            
            if False == iRet[0] and unbalancedNum <10:
                unbalancedNum += 1
                cliRet += '\n\n' + iRet[1]
                """lun负载均衡巡检项CLI回显过长 20130830 added End"""
            
            tempOwnController = iRet[2]
            tempWorkController = iRet[3]
            #设置错误显示信息

            
            if False == iRet[0]:
                flag = False
                if "zh" == lang:
                    errMsg += u"\nLun" + str(lunId)+ u"的负载不均衡, 所属控制器为" + str(tempOwnController)\
                                + u",工作控制器为" + str(tempWorkController) + u"。"
                else:
                    errMsg += "\nThe load balance status of Lun" + str(lunId) +" is not normal, Owning Controller is "\
                                + str(tempOwnController) + u", Working Controller is " + str(tempWorkController) + u"."
    return (flag, cliRet, errMsg)
    

def checklunloadbalance(cli, lunId):
    
    """cli命令回显信息
    admin:/>showlun -lun 0    
    ===================================================================
                              LUN Information
    -------------------------------------------------------------------
      ID                           | 0
      Name                         | LUN001
      LUN WWN                      | 630397510068393001869d9b00000000
      Status                       | Normal
      Visible Capacity(MB)         | 57344.0
      Stripe Unit Size(KB)         | 64
      RAID Group ID                | 0
      Format Progress(%)           | --
      Owning Controller            | A
      Working Controller           | A
      Cache Prefetch Strategy      | Intelligent
      Cache Write Strategy         | Write back; Mirroring
      Running Cache Write Strategy | Write back; Mirroring
      Change stripped size         | --
      Stripe Unit Size Progress(%) | --
      Stripe Unit Size Speed       | --
      Extending LUN                | --
      Lun Type                     | FAT
      Consumed Capacity(MB)        | --
      Reclaim Progress(%)          | --
      Pool ID                      | --
      SnapShot ID                  | 6
      LunCopy ID                   | 0
      Whether Private LUN          | No
      Remote Replication ID        | 3039756839300000
      Split mirror ID              | --
    ===================================================================
        
    admin:/>"""
    #信息初始化
    OwnController = ''
    WorkController = ''
    flag = True
    
    cliRet = cli.execCmd("showlun -lun " + str(lunId))
    list = string.split(cliRet, '\n')
    
    """判断cli回显信息是否满足要求"""
    #P11G-5704 私有Lun不进行检查 added 20130218 Begin
    count = len(list)
    for index in range(count):
        if re.search('Whether Private LUN', list[index], re.IGNORECASE):
            if re.search('Yes', list[index], re.IGNORECASE):
                return (True, cliRet, '', '')
            else:
                break
        else:
            continue

    if count < 33:
        return(False, cliRet, '', '')
    #P11G-5704 私有Lun不进行检查 added 20130218 End

    """查询制定Lun的控制器信息"""
    OwnController = (list[12].split())[3]
    WorkController = (list[13].split())[3] 
    
    if OwnController != WorkController:
        flag = False
    return(flag, cliRet, str(OwnController), str(WorkController))

"""P11G-5580 Lun负载均衡巡检项增加 20121204 added End"""
 