﻿# -*- coding: UTF-8 -*-

"""P11G-5580 Lun回写不镜像巡检项增加 20121204 added Begin"""
import re
import string

"""查询Lun回写不镜像"""
def execute(cli):
    """"cli命令回显信息
    showlun
    =========================================================================================================================================
                                                LUN Information
    -----------------------------------------------------------------------------------------------------------------------------------------
      ID    RAID Group ID    Disk Pool ID    Status    Controller    Visible Capacity(MB)    LUN Name      Stripe Unit Size(KB)    Lun Type  
    -----------------------------------------------------------------------------------------------------------------------------------------
      0     0                --              Normal    A             57344.0                 LUN001        64                      FAT       
      1     0                --              Normal    B             57344.0                 LUN002        64                      FAT       
      2     1                --              Normal    A             96256.0                 LUN003_001    64                      FAT       
    =========================================================================================================================================
    
    admin:/>"""
    
    tempCacheWriteStrategy = ""
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""

    cliRet = cli.execCmd("showlun")
    list = cliRet.splitlines()
    """判断cli回显信息是否满足要求"""
    if len(list) < 9:
        return (True, cliRet, errMsg)
        
    """lun回写不镜像巡检项CLI回显过长 20130830 added begin"""
    writeBackNoMirrorNum = 0
    
    for field in list[6:]:
        
        luninfo = field.split()
        if len(luninfo) < 9:
            continue
        else:
            lunId = luninfo[0]
            #查询每一个Lun的回写不镜像状态
            iRet = checkwritebacknomirror(cli, lunId)
            
            if False == iRet[0] and writeBackNoMirrorNum < 10:
                writeBackNoMirrorNum += 1
                cliRet += '\n\n' + iRet[1]
                """lun回写不镜像巡检项CLI回显过长 20130830 added end"""
            
            tempCacheWriteStrategy = iRet[2]
            #设置错误显示信息
            if False == iRet[0]:                
                flag = False  
                if "zh" == lang:
                    errMsg += u"\nLun" + str(lunId)+ u"运行的Cache写策略异常，" + u"Cache写策略为" \
                                + str(tempCacheWriteStrategy) + u"。"
                else:
                    errMsg += "\nThe running cache write strategy of Lun" + str(lunId) +" is not normal, running cache write strategy is "\
                                + str(tempCacheWriteStrategy) + u"."
    return (flag, cliRet, errMsg)
    

def checkwritebacknomirror(cli, lunId):
    
    """cli命令回显信息
    admin:/>showlun -lun 0    
    ===================================================================
                              LUN Information
    -------------------------------------------------------------------
      ID                           | 0
      Name                         | LUN001
      LUN WWN                      | 630397510068393001869d9b00000000
      Status                       | Normal
      Visible Capacity(MB)         | 57344.0
      Stripe Unit Size(KB)         | 64
      RAID Group ID                | 0
      Format Progress(%)           | --
      Owning Controller            | A
      Working Controller           | A
      Cache Prefetch Strategy      | Intelligent
      Cache Write Strategy         | Write back; Mirroring
      Running Cache Write Strategy | Write back; Mirroring
      Change stripped size         | --
      Stripe Unit Size Progress(%) | --
      Stripe Unit Size Speed       | --
      Extending LUN                | --
      Lun Type                     | FAT
      Consumed Capacity(MB)        | --
      Reclaim Progress(%)          | --
      Pool ID                      | --
      SnapShot ID                  | 6
      LunCopy ID                   | 0
      Whether Private LUN          | No
      Remote Replication ID        | 3039756839300000
      Split mirror ID              | --
    ===================================================================
        
    admin:/>"""
    #信息初始化
    RunCacheWriteStrategy = ''
    flag = True
    
    cliRet = cli.execCmd("showlun -lun " + str(lunId))
    list = string.split(cliRet, '\n')
    
    """判断cli回显信息是否满足要求"""
    #P11G-5704 私有Lun不进行检查 added 20130218 Begin
    count = len(list)
    for index in range(count):
        if re.search('Whether Private LUN', list[index], re.IGNORECASE):
            if re.search('Yes', list[index], re.IGNORECASE):
                return (True, cliRet, '', '')
            else:
                break
        else:
            continue

    if count < 33:
        return(False, cliRet, '', '')
    #P11G-5704 私有Lun不进行检查 added 20130218 End

    """查询lun的运行cache写策略"""
    for field in list:
        if bool(re.search('Running Cache Write Strategy', field, re.IGNORECASE)):
            #回写不镜像查询
            if bool(re.search('Write back; No mirroring', field, re.IGNORECASE)):
                RunCacheWriteStrategy = 'Write back; No mirroring'
                flag = False
            else:
                RunCacheWriteStrategy = field.replace('Running Cache Write Strategy | ', '')
                flag = True
            break

    return(flag, cliRet, RunCacheWriteStrategy)

"""P11G-5580 Lun回写不镜像巡检项增加 20121204 added End"""
 