﻿# -*- coding: UTF-8 -*-

#P11G-5702 休眠的Raid组的Lun不用检查 added 20130219 Begin
"""P11G-5580 Cache写策略巡检项增加 20121204 added Begin"""
import re
import string

"""查询Lun的Cache写策略"""
def execute(cli):

    tempwritestrategy = ""
    temprunwritestrategy = ""
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""
    cliRet = ""

    lunInfoDict = {'LunID':'', 'RGID':'', 'PoolID':''}
    allLunInfoList = []
    lunId = ''
    thinPoolId = ''
    raidGroupId = ''

    iRet = getLunAndRaidGroupList(cli)
    cliRet = iRet[0]
    allLunInfoList = iRet[1]
    
    """cache写策略巡检项CLI回显过长 20130830 added begin"""
    errNum = 0
    cliTmpMsg = ''

    """轮训查询每一个Lun是否Cache写策略正确"""
    for lunInfoDict in allLunInfoList:
        
        lunId = lunInfoDict['LunID']
        raidGroupId = lunInfoDict['RGID']
        thinPoolId = lunInfoDict['PoolID']         
        #查询指定Lun的Cache写策略状态
        iRet = checkCacheWriteStrategy(cli, lunId)
        
        if False == iRet[0]:
            cliTmpMsg = iRet[1]
        """cache写策略巡检项CLI回显过长 20130830 added end"""
            
        tempwritestrategy = iRet[2]
        temprunwritestrategy = iRet[3]

        if False == iRet[0]:
        
            """查询不通过的Lun是否需要检查"""
            #P11G-5804 cache写策略巡检项优化  20131010， modified begin
            iRet = whetherLunNeedCheck(cli, lunId, raidGroupId, thinPoolId, allLunInfoList)
            #P11G-5804 cache写策略巡检项优化  20131010， modified begin   
            if False == iRet[0]:
                continue
            
            """lun回写不镜像巡检项CLI回显过长 20130910 added begin"""
            if errNum < 10:
                cliRet += '\n\n' + cliTmpMsg + '\n\n' + iRet[1]
                errNum += 1
            """lun回写不镜像巡检项CLI回显过长 20130910 added end"""
            
            flag = False
            if "zh" == lang:
                errMsg += u"\nLun" + str(lunId)+ u"的Cache写策略异常, 配置的Cache写策略为" + str(tempwritestrategy)\
                            + u",当前运行的Cache写策略为" + str(temprunwritestrategy) + u"。"
            else:
                errMsg += "\nThe cache write strategy of Lun" + str(lunId) +" is not normal, Cache Write Strategy is "\
                            + str(tempwritestrategy) + u", Running Cache Write Strategy is " + str(temprunwritestrategy) + u"."

    return (flag, cliRet, errMsg)
#P11G-5702 休眠的Raid组的Lun不用检查 added 20130219 En!d    

def checkCacheWriteStrategy(cli, lunId):
    
    """cli命令回显信息
    admin:/>showlun -lun 0    
    ===================================================================
                              LUN Information
    -------------------------------------------------------------------
      ID                           | 0
      Name                         | LUN001
      LUN WWN                      | 630397510068393001869d9b00000000
      Status                       | Normal
      Visible Capacity(MB)         | 57344.0
      Stripe Unit Size(KB)         | 64
      RAID Group ID                | 0
      Format Progress(%)           | --
      Owning Controller            | A
      Working Controller           | A
      Cache Prefetch Strategy      | Intelligent
      Cache Write Strategy         | Write back; Mirroring
      Running Cache Write Strategy | Write back; Mirroring
      Change stripped size         | --
      Stripe Unit Size Progress(%) | --
      Stripe Unit Size Speed       | --
      Extending LUN                | --
      Lun Type                     | FAT
      Consumed Capacity(MB)        | --
      Reclaim Progress(%)          | --
      Pool ID                      | --
      SnapShot ID                  | 6
      LunCopy ID                   | 0
      Whether Private LUN          | No
      Remote Replication ID        | 3039756839300000
      Split mirror ID              | --
    ===================================================================
        
    admin:/>"""
    #信息初始化
    tempwritestrategy = ""
    temprunwritestrategy = ""
    flag = True
    
    cliRet = cli.execCmd("showlun -lun " + str(lunId))
    list = cliRet.splitlines()
    
    """判断cli回显信息是否满足要求"""
    #P11G-5704 私有Lun不进行检查 added 20130218 Begin
    count = len(list)
    for index in range(count):
        if re.search('Whether Private LUN', list[index], re.IGNORECASE):
            if re.search('Yes', list[index], re.IGNORECASE):
                return (True, cliRet, '', '')
            else:
                break
        else:
            continue

    if count < 33:
        return(False, cliRet, '', '')
    #P11G-5704 私有Lun不进行检查 added 20130218 End

    """查询lun的cache写策略"""
    for field in list:
        #取得运行的cache写策略
        if bool(re.search('Running Cache Write Strategy', field, re.IGNORECASE)):
            #取得运行的cache写策略
            temprunwritestrategy = field.replace('Running Cache Write Strategy |', '').lstrip()
            continue
        
        #查询配置的cache写策略
        if bool(re.search('Cache Write Strategy', field, re.IGNORECASE)):
            #取得配置的cache写策略
            tempwritestrategy = field.replace('Cache Write Strategy', '').replace('|', '').lstrip()
            continue

    """P11A-7808 巡检判断标准修改 20121226 modified Begin"""
    writestrategy = tempwritestrategy.replace(' mandatory', '')
    
    if temprunwritestrategy != writestrategy:
        flag = False
    """P11A-7808 巡检判断标准修改 20121226 modified End"""
    return(flag, cliRet, tempwritestrategy, temprunwritestrategy)

"""P11G-5580 Cache写策略巡检项增加 20121204 added End"""

#P11G-5702 休眠的Raid组的Lun不用检查 added 20130219 Begin
# **************************************************************************** #
# 函数名称:  checkSpinDownRaidGroup
# 功    能:   查询当前Lun是否需要检查：休眠Raid组的普通Lun + 扩展Lun的主从Lun所属Raid组存在休眠情况  = 不需要检查
# 输入参数:  cli, raidGroupId
# 输出参数:  无
# 返回值  :   flag：是否在休眠状态标志
# 其 他   :    无
#**************************************************************************#
def getLunAndRaidGroupList(cli):
    """"cli命令回显信息
    showlun
    =========================================================================================================================================
                                                LUN Information
    -----------------------------------------------------------------------------------------------------------------------------------------
      ID    RAID Group ID    Disk Pool ID    Status    Controller    Visible Capacity(MB)    LUN Name      Stripe Unit Size(KB)    Lun Type  
    -----------------------------------------------------------------------------------------------------------------------------------------
      0     0                --              Normal    A             57344.0                 LUN001        64                      FAT       
      1     0                --              Normal    B             57344.0                 LUN002        64                      FAT       
      2     1                --              Normal    A             96256.0                 LUN003_001    64                      FAT       
    =========================================================================================================================================
    
    admin:/>"""

    allLunInfoList = []

    cliRet = cli.execCmd("showlun")
    list = cliRet.splitlines()
    """判断cli回显信息是否满足要求"""
    if len(list) < 9:
        return (cliRet, allLunInfoList)
    
    for field in list[6:]:
        lunInfoDict = {'LunID':'', 'RGID':'', 'PoolID':''}

        luninfo = field.split()
        if len(luninfo) < 7:
            break
        
        lunInfoDict['LunID'] = luninfo[0]
        lunInfoDict['RGID'] = luninfo[1]
        lunInfoDict['PoolID'] = luninfo[2]
        allLunInfoList.append(lunInfoDict)
    
    return (cliRet, allLunInfoList)   
            
# **************************************************************************** #
# 函数名称:  checkSpinDownRaidGroup
# 功    能:   查询当前Lun是否需要检查：休眠Raid组的普通Lun + 扩展Lun的主从Lun所属Raid组存在休眠情况  = 不需要检查
# 输入参数:  cli, raidGroupId
# 输出参数:  无
# 返回值  :   flag：是否在休眠状态标志
# 其 他   :    无
#**************************************************************************#
'''P11G-5804 cache写策略巡检项优化  20131010， modified begin '''
def whetherLunNeedCheck(cli, lunId, raidGroupId, thinPoolId, allLunInfoList):
    '''P11G-5804 cache写策略巡检项优化  20131010， modified end '''
    """showextlunmember -ext 1
    =====================================================================================
                              Extending LUN Member Information
    -------------------------------------------------------------------------------------
      LUN ID    LUN Name      Relation    Capacity(MB)    RAID Group Name    RAID Level  
    -------------------------------------------------------------------------------------
      4         LUN001_002    Master      2048.0          RAID001            RAID5       
      2         LUN001_003    Slave       2048.0          RAID002            RAID0       
      3         LUN001_004    Slave       2048.0          RAID002            RAID0       
    =====================================================================================
    
    admin:/>"""

    flag = True
    lunCheckRGIDList = []
    '''P11G-5804 cache写策略巡检项优化  20131010， modified begin '''
    lunCheckPOOLList = []
    '''P11G-5804 cache写策略巡检项优化  20131010， modified end '''
    lunInfoDict = {'LunID':'', 'RGID':''}
    allCliRet = ''
    
    """查询是否为扩展Lun"""
    '''P11G-5804 cache写策略巡检项优化  20131010， modified begin '''
    if raidGroupId == '--' and thinPoolId == '--':
        '''P11G-5804 cache写策略巡检项优化  20131010， modified end '''
        cliRet = cli.execCmd("showextlunmember -ext " + str(lunId))
        allCliRet += '\n\n' + cliRet
        
        """判断cli回显信息是否满足要求"""
        if not re.search('Extending LUN Member Information', cliRet, re.IGNORECASE):
            return (True, allCliRet)

        list = cliRet.splitlines()
        if len(list) < 9:
            return (True, allCliRet)
        
        """获取扩展Lun：需要查询是否休眠的Raid组列表"""
        for field in list[6:]:
            
            luninfo = field.split()
            if len(luninfo) < 5:
                break

            lunId = luninfo[0]
            for lunInfoDict in allLunInfoList:
                if lunId == lunInfoDict['LunID']:
                    if lunInfoDict['RGID'] not in lunCheckRGIDList:
                        lunCheckRGIDList.append(lunInfoDict['RGID'])
                    else:
                        break
                else:
                    continue
    #P11G-5804 cache写策略巡检项优化  20131010， modified begin
    #Thin lun
    elif raidGroupId == '--' and thinPoolId != '--':
        lunCheckPOOLList.append(thinPoolId)
    #Ordinary lun
    #P11G-5804 cache写策略巡检项优化  20131010， modified end
    else:       
         lunCheckRGIDList.append(raidGroupId)
    
    """轮训查询Raid组是否休眠中"""
    for raidId in lunCheckRGIDList:
        iRet = checkSpinDownRaidGroup(cli, raidId)
        allCliRet += '\n\n' + iRet[1]
        if True == iRet[0]:
            return (False, allCliRet)
        else:
            continue
    #P11G-5804 cache写策略巡检项优化  20131010， modified begin    
    #轮训查询pool是否休眠中
    for poolId in lunCheckPOOLList:
        iRet = checkSpinDownThinPool(cli, poolId)
        allCliRet += '\n\n' + iRet[1]
        if True == iRet[0]:
            return (False, allCliRet)
        else:
            continue
    #P11G-5804 cache写策略巡检项优化  20131010， modified end    
    return (True, allCliRet)

# **************************************************************************** #
# 函数名称:  checkSpinDownRaidGroup
# 功    能:   查询当前的Raid组是否在休眠状态（定时休眠+不定时休眠）
# 输入参数:  cli, raidGroupId
# 输出参数:  无
# 返回值  :   flag：是否在休眠状态标志
# 其 他   :    无
#**************************************************************************#
def checkSpinDownRaidGroup(cli, raidGroupId):
    
    flag = False
    allCliRet = ''

    """检查定时休眠Raid组"""
    """ 
    showrgprdspindown -rg 3
    ======================================================================================================================================
                                                               Time Information
    --------------------------------------------------------------------------------------------------------------------------------------
      RAID Group ID    Spindown Status    Valid Days    Start Time1    End Time1    Start Time2    End Time2    Start Time3    End Time3  
    --------------------------------------------------------------------------------------------------------------------------------------
      3                Spindown           Every Day     14:26:00       18:30:00     19:26:00       23:30:00     00:00:00       00:00:00   
    ======================================================================================================================================
    
    admin:/
    """
    cliRet = cli.execCmd("showrgprdspindown -rg " + str(raidGroupId))
    allCliRet += cliRet

    if re.search('Time Information', cliRet, re.IGNORECASE):
        timerList = cliRet.splitlines()
        counter = len(timerList)
        
        if counter > 7:
            if re.search('Not Spindown', timerList[6], re.IGNORECASE):
                flag = False
            elif re.search('Spindown', timerList[6], re.IGNORECASE):
                flag = True
            else:
                flag = False
    
    if True == flag:
        return (flag, allCliRet)
                
    """检查不定时休眠Raid组"""
    """
    >showrgiospindown -rg 0 
    ======================================
         RAID IO Spindown Information
    --------------------------------------
      RAID Group ID       | 0
      Is Spindown Allowed | No
      Spindown Status     | Not Spindown
      Idle Time(s)        | --
    ======================================
    
    admin:/
    """
    cliRet = cli.execCmd("showrgiospindown -rg " + str(raidGroupId))
    allCliRet += '\n\n' + cliRet
    
    if re.search('RAID IO Spindown Information', cliRet, re.IGNORECASE):
        IOSpindownInfo = cliRet.splitlines()
        counter = len(IOSpindownInfo)
        
        for index in range(counter):
            if re.search('Spindown Status', IOSpindownInfo[index], re.IGNORECASE):
                if re.search('Not Spindown', IOSpindownInfo[index], re.IGNORECASE):
                    flag = False
                else:
                    flag = True 
    return (flag, allCliRet)
#P11G-5702 休眠的Raid组的Lun不用检查 added 20130219 End

#P11G-5804 cache写策略巡检项优化  20131010， modified begin
# **************************************************************************** #
# 函数名称:  checkSpinDownThinPool
# 功    能:   查询当前的thinpool是否在休眠状态（定时休眠+不定时休眠）
# 输入参数:  cli, poolId
# 输出参数:  无
# 返回值  :   flag：是否在休眠状态标志
# 其 他   :    无
#**************************************************************************#
def checkSpinDownThinPool(cli, poolId):
    
    flag = False
    allCliRet = ''
                
    """check spindown status of a thinpool
    >showpooliospindown -pool 2
    ======================================
         Pool IO Spindown Information
    --------------------------------------
      Pool ID             | 2
      Is Spindown Allowed | Yes
      Spindown Status     | Not Spindown
      Idle Time(s)        | 600
    ======================================
    
    admin:/>
    """
    cliRet = cli.execCmd("showpooliospindown -pool " + str(poolId))
    allCliRet += '\n\n' + cliRet
    
    if re.search('Pool IO Spindown Information', cliRet, re.IGNORECASE):
        IOSpindownInfo = cliRet.splitlines()
        counter = len(IOSpindownInfo)
        
        for index in range(counter):
            if re.search('Spindown Status', IOSpindownInfo[index], re.IGNORECASE):
                if re.search('Not Spindown', IOSpindownInfo[index], re.IGNORECASE):
                    flag = False
                else:
                    flag = True 
    return (flag, allCliRet)
#P11G-5804 cache写策略巡检项优化  20131010， modified end
 