# -*- coding: UTF-8 -*-

"""P11G-5580 iscsi链路速率 20121204 added Begin"""
import re

"""iSCSI链路速率巡检"""
def execute(cli):
    """admin:/>showiscsispeed
    ========================================================================================
                                        iSCSI Port Speed
    ----------------------------------------------------------------------------------------
      Controller ID    Interface Module ID    Port ID    Current Speed                      
    ----------------------------------------------------------------------------------------
      A                0                      P0         --                                 
      A                0                      P1         --                                                                 
      A                1                      H4         1000Mbps, Full Duplex, Autoneg ON  
      A                1                      H5         --                                                               
      B                1                      H3         --                                 
      B                1                      H4         1000Mbps, Full Duplex, Autoneg ON  
      B                1                      H5         --                                 
    ========================================================================================"""
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    curspeedtemp = ""
    lang = py_java_env.get("lang")
    errMsg = ""

    cliRet = cli.execCmd("showiscsispeed")
    list = cliRet.splitlines()
    if len(list) < 7:
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 4:
            continue
        #P11A-7819 10Gbps速率显示修改 modified 20130218 Begin
        if list2[3] not in ("--", "1000Mbps,", "10Gbps,"):
            curspeedtemp = field[field.index(list2[3]):]
            flag = False
            if "zh" == lang:
                errMsg += u"\n控制器" + list2[0] + u"，iscsi接口" + list2[1] + u"，网口" + list2[2]\
                                + u"的速度存在异常（" + curspeedtemp + u"）。"
                   
            else:
                errMsg += "\nThe iscsi port" + list2[2] + u", interface module " + list2[1]\
                                + u" of controller " + list2[0] + u" is abnormal(" + curspeedtemp + ")."
        #P11A-7819 10Gbps速率显示修改 modified 20130218 End

    return (flag, cliRet, errMsg)

"""P11G-5580 iscsi链路速率 20121204 added End"""