# -*- coding: UTF-8 -*-

"""P11G-5580 FC链路速率 20121204 added Begin"""
import re

"""FC链路速率巡检"""
def execute(cli):
    """admin:/>showfcspeed
    ============================================================================================================
                                                   FC Port Speed
    ------------------------------------------------------------------------------------------------------------
      Controller ID    Interface Module ID    Port ID    WWN                 Current Speed    Configured Speed  
    ------------------------------------------------------------------------------------------------------------
      A                0                      P0         20000022a10b6c5c    8Gbps            --                
      A                0                      P1         20010022a10b6c5c    --               --                               
      B                0                      P2         20120022a10b6c5c    --               --                
      B                0                      P3         20130022a10b6c5c    --               --                
    ============================================================================================================
    """"""
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    curspeedtemp = ""
    confspeedtemp = ""
    lang = py_java_env.get("lang")
    errMsg = ""

    cliRet = cli.execCmd("showfcspeed")
    list = cliRet.splitlines()
    if len(list) < 7:
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 6:
            continue
        
        curspeedtemp = list2[4]
        confspeedtemp = list2[5]
        
        if curspeedtemp not in ("--", "AUTO", "1Gbps" , "2Gbps" ,"4Gbps" ,"8Gbps" )\
            or confspeedtemp not in ("--", "AUTO", "1Gbps" , "2Gbps" ,"4Gbps" ,"8Gbps" ):

            flag = False
            if "zh" == lang:
                errMsg += u"\n控制器" + list2[0] + u"，FC接口" + list2[1] + u"，端口" + list2[2] \
                            + u"的速度存在异常（" + u"当前速度为：" + curspeedtemp + u",配置速度为：" + confspeedtemp + u"）。"
                   
            else:
                errMsg += "\nThe fc port" + list2[2] + u", interface module " + list2[1] + u" of controller "\
                            + list2[0] + u" is abnormal(" + u"Current Speed：" + curspeedtemp + u",Configured Speed：" + confspeedtemp + ")."

    return (flag, cliRet, errMsg)

"""P11G-5580 FC链路速率 20121204 added End"""