# -*- coding: UTF-8 -*-

"""云备份任务巡检 20121204 added Begin"""
import re

"""云备份任务巡检"""
def execute(cli):
    """
    admin:/>showcloudbackup
    ===============================================================================
                           Cloud Backup Information
    -------------------------------------------------------------------------------
      Cloud Backup ID    Cloud Backup Name    Running Status        Health Status  
    -------------------------------------------------------------------------------
      0                  CloudBackup001       Copying               Normal         
      1                  CloudBackup002       Copy Completed        Normal         
      2                  CloudBackup003       Recovery Completed    Normal         
      3                  CloudBackup004       Copying               Normal         
    ==============================================================================="""


    flag = True
    cloudBackUpId = ""
    cloudBackUpName = ""
    healthStatus = ""
    lang = py_java_env.get("lang")
    errMsg = ""

    cliRet = cli.execCmd("showcloudbackup")
    list = cliRet.splitlines()
    if len(list) < 7:
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 4:
            continue
        
        cloudBackUpId = list2[0]
        cloudBackUpName = list2[1]
        
        if bool(re.search("Fault", field, re.IGNORECASE)):
            flag = False
            if "zh" == lang:
                errMsg += u"\n云备份任务（ID：" + cloudBackUpId + u"，名称：" + cloudBackUpName + u"）的健康状态存在异常（Fault）。"
            else:
                errMsg += u"\nThe health status of Cloudbackup task (ID:" + cloudBackUpId + u"，name:" + cloudBackUpName + u") is abnormal（Fault）."

    return (flag, cliRet, errMsg)

"""云备份任务巡检 20121204 added End"""