# -*- coding: UTF-8 -*-

"""Wifi模块功能巡检 20121204 added Begin"""

"""Wifi模块功能巡检"""
def execute(cli):
    """
    admin:/>showwifi 
    ===============================================================================
                                   Wi-Fi Information
    -------------------------------------------------------------------------------
      Status           | Signal Close
      Link Status      | Link Down
      SSID             | XX@210235G6T8Z0C3000005
      Silent Time      | 10
      Channel          | 1
      Ip Address       | 172.16.128.101
      Ip Mask          | 255.255.0.0
      GateWay          | 172.16.0.1
      Electronic Label | /$[ArchivesInfo Version]
                       | /$ArchivesInfoVersion=3.0
                       |  
                       |  
                       | [Board Properties]
                       | BoardType=STL1EARD
                       | BarCode=02G34N1234567890
                       | Item=0302G34N
                       | Description=PANGEA,STL1EARD,WIFI  Auxiliary Card,V100R005,10*1
                       | Manufactured=2012-11-19
                       | VendorName=
                       | IssueNumber=00
                       | CLEICode=
                       | BOM=
    ==============================================================================="""

    flag = True
    WifiModuleStatus = ""
    lang = py_java_env.get("lang")
    errMsg = ""

    cliRet = cli.execCmd("showwifi")

    list = cliRet.splitlines()
    if len(list) < 7:
        return (flag, cliRet, errMsg)

    WifiModuleStatus = (list[4].replace(" ", "").split("|"))[1]
    
    if "Fault" == WifiModuleStatus:
        flag = False
        if "zh" == lang:
            errMsg += u"\nWifi功能状态存在异常（Fault）。"
        else:
            errMsg += u"\nThe status of Wifi module is abnormal（Fault）."

    return (flag, cliRet, errMsg)

"""Wifi模块功能巡检 20121204 added End"""