# -*- coding: UTF-8 -*-
import re

""" 性能转储巡检 20130709 added Begin"""

# ************************************************************************ #
# 函数名称:  checkCliInfoValid
# 功能说明:  检查CLI回显有效性
# 输入参数:  cliInfo CLI回文信息
# 输出参数:  无
# 返回值  :  license、执行成功、不存在，返回值通过，其他不通过。
# 其 他   :  无
#**************************************************************************#   
def checkCliInfoValid(cliInfo):
    #性能转储巡检项优化 20130922 modified begin
    if re.search("command operates successfully", cliInfo, re.IGNORECASE):
        flag = True    
    elif re.search("license", cliInfo, re.IGNORECASE):
        flag = True
    elif re.search("not exist", cliInfo, re.IGNORECASE):
    #性能转储巡检项优化 20130922 modified end
        flag = True
    else:
        flag = False    
        
    return(flag, cliInfo)


def execute(cli):
    """
    admin:/>showupgradepkginfo -t 1
    ========================================================
    			  Upgrade Package Information
    --------------------------------------------------------
      Controller ID    Package Version      Package Status
    --------------------------------------------------------
      A                V100R005C00SPC800    Running
      B                V100R005C00SPC800    Running
    ========================================================
    admin:/>
    
    admin:/>showperfrestore
    =================================
     Statistic Restore Configuration
    ---------------------------------
      Restore Switch  | off
      Restore Address |
      Restore Path    |
      Restore Account |
    =================================
    admin:/>
    
    admin:/>hw_chgalarmmask -i 60163817496 -m 1
    command operates successfully.
    admin:/>
    
    admin:/>hw_showalarmmask
    ==========================
    		 Mask ID
    --------------------------
      alarm id | 60163817496
    ==========================
    """
    AlarmMask = False
    flag = True
    lang = py_java_env.get("lang")
    curCVersion = ""
    currentVer = ""
    version = ""
    errMsg = ""
    cliRet = ""
    iRet = ""
    iReturn = ""
    
    #性能转储巡检项优化 20130922 added begin
    iRet = cli.execCmd("showperfswitch")
    cliRet += iRet
    if re.search("off", cliRet, re.IGNORECASE):
        return (True, cliRet, "")
    #性能转储巡检项优化 20130922 added end
    
    iRet = cli.execCmd("hw_showalarmmask")
    cliRet += iRet

    if re.search("60163817496", iRet):
        AlarmMask = True
    

    #"""获取系统软件版本号,判断是否需要提示屏蔽""" 
    iRet = cli.execCmd("showupgradepkginfo -t 1")
    cliRet += iRet
    
    list = iRet.splitlines()
    if len(list) < 7:
        iReturn = checkCliInfoValid(iRet)
        flag = iReturn[0]
        return (flag, cliRet, errMsg)
    
    # 从第7行开始，取出有效信息
    for line in list[6:]:
        field = line.split()
        if len(field) < 3:
            break
    
        # 只取出正在运行的版本号
        if "Running" == field[2]:
            # 构造版本信息字符串
            version = field[1]
            #示例：V100R002C00SPCh00
            currentVer = version[version.index("V100"):version.index("V100") + 17]
            #示例：V100R002C00
            curCVersion = version[version.index("V100"):version.index("V100") + 11]

            break
        
    #检查当前版本是否需要修复
    if "V100R002C00" == curCVersion:
        if currentVer >= "V100R002C00SPC015" and currentVer <= "V100R002C00SPCh00":
            if False == AlarmMask:
                flag = False  
        elif currentVer > "V100R002C00SPCh00":
            if True == AlarmMask:
                flag = False

    elif "V100R002C01" == curCVersion:
        if currentVer >= "V100R002C01SPC015" and currentVer <= "V100R002C01SPCh00":
            if False == AlarmMask:
                flag = False                      
        elif currentVer > "V100R002C01SPCh00":
            if True == AlarmMask:
                flag = False
            
    elif "V100R005C00" == curCVersion:
        if currentVer >= "V100R005C00SPC003" and currentVer <= "V100R005C00SPC700":
            if False == AlarmMask:
                flag = False      
        elif currentVer > "V100R005C00SPC700":
            if True == AlarmMask:
                flag = False
                
    elif "V100R005C01" == curCVersion:
        if currentVer >= "V100R005C01SPC003" and currentVer <= "V100R005C01SPC700":
            if False == AlarmMask:
                flag = False  
        elif currentVer > "V100R005C01SPC700":
            if True == AlarmMask:
                flag = False
    #性能转储巡检项优化 20130922 added begin
    elif "V100R005C02" == curCVersion:
        if True == AlarmMask:
            flag = False
    #性能转储巡检项优化 20130922 added end
	
    
    if False == flag:   
        #未打开，建议打开
        if False == AlarmMask:
           if "zh" == lang:
               #性能转储巡检项优化 20130922 deleted
               errMsg += u"\n步骤1：以admin用户登录设备。"
               errMsg += u"\n步骤2：执行CLI命令 hw_chgalarmmask -i 60163817496 -m 1， 请等待执行完成后再重新检查一次。"
               errMsg += u"\n步骤3: 如果有任何疑问，请联系技术支持工程师协助解决。"
           else:
               #性能转储巡检项优化 20130922 deleted
               errMsg += "\nStep 1  Log in to the device as user admin."
               errMsg += "\nStep 2  Run the hw_chgalarmmask -i 60163817496 -m 1 command, wait until the command operates successfully and then perform a check."
               errMsg += "\nStep 3  If you have any questions, please contact technical support engineers for further handling."    
        #已打开，建议关闭
        else:
           if "zh" == lang:
               #性能转储巡检项优化 20130922 deleted
               errMsg += u"\n步骤1：以admin用户登录设备。"
               errMsg += u"\n步骤2：执行CLI命令 hw_chgalarmmask -i 60163817496 -m 0， 请等待执行完成后再重新检查一次。"
               errMsg += u"\n步骤3: 如果有任何疑问，请联系技术支持工程师协助解决。"
           else:
               #性能转储巡检项优化 20130922 deleted
               errMsg += "\nStep 1  Log in to the device as user admin."
               errMsg += "\nStep 2  Run the hw_chgalarmmask -i 60163817496 -m 0 command, wait until the command operates successfully and then perform a check."
               errMsg += "\nStep 3  If you have any questions, please contact technical support engineers for further handling."   
    else:
        errMsg = ""
                                        
    return (flag, cliRet, errMsg)

""" 性能转储巡检 20130709 added End """