#!/bin/sh


CMD_FILE=./cmd_tmp_file

PrintNotInstallUp()
{
   isPass=3
   errResult="UltraPath is not installed on this host, skip this item."  
        
   WRITE_XML_ERROR 0 ":${errResult}"
   WRITE_XML_JUDGE $isPass
   WRITE_XML_SUBCMD_TAIL
   return 1;
}

PrintUpadmFileNotExist()
{
   isPass=3
   errResult="#upadm show version
   upadm: command not found" 
   
   WRITE_XML_ERROR 0 ":${errResult}"
   WRITE_XML_JUDGE $isPass
   WRITE_XML_SUBCMD_TAIL
   return 1; 
}


HOST_01_ChkUltraPathVersion()
{
    errResult=""
    isPass=0
    
    WRITE_XML_SUBCMD_HEADER $1
    
    if [ ${UltraPath_Flag}  -eq 1 ]; then
        PrintNotInstallUp
        return 1;
    fi
    
    UltraPath_VERSION=`echo "#pkgparam UltraPath VERSION";pkgparam UltraPath VERSION`
    
    WRITE_XML_COMMON 0 ":${UltraPath_VERSION}"
    
    if [ ${Upadm_Flag}  -eq 1 ]; then
        PrintUpadmFileNotExist
        return 1;
    fi
    
    UltraPath_VERSION=`echo "#upadm show version";upadm show version`
    WRITE_XML_COMMON 0 ":${UltraPath_VERSION}"
   
    
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}


HOST_02_ChkUpServer()
{
    errResult=""
    isPass=0
    
    WRITE_XML_SUBCMD_HEADER $1
    
    if [ ${UltraPath_Flag}  -eq 1 ]; then
        PrintNotInstallUp
        return 1;
    fi    
    
    
    ps -ef|grep -v grep|grep upservice > /dev/null 2>&1
    
    if [ $? -ne 0 ]; then
        isPass=1
        errResult="INFO:The status of upservice is abnormal!"  
    fi
    
   
    if [ "$errResult" != "" ];then 
        WRITE_XML_ERROR 0 ":${errResult}"
    fi 
    
    UltraPath_VERSION=`echo "#ps -ef|grep -v grep|grep upservice";ps -ef|grep -v grep|grep upservice`
    WRITE_XML_COMMON 1 ":${UltraPath_VERSION}"
    

    UltraPath_VERSION=`echo "#svcs -l upservice";svcs -l upservice`
    WRITE_XML_COMMON 1 ":${UltraPath_VERSION}"
    
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}


HOST_03_ChkUpFiles()
{
    errResult=""
    isPass=0
        
    DRV_DIR=/kernel/drv/sparcv9	

    
    WRITE_XML_SUBCMD_HEADER $1

    if [ ${UltraPath_Flag}  -eq 1 ]; then
        PrintNotInstallUp
        return 1;
    fi
        
    if [ ! -f /usr/bin/.upservice ]; then
        isPass=1
        errResult="INFO:Not found file:/usr/bin/.upservice"  
        WRITE_XML_ERROR 0 ":${errResult}"    
    fi
    
    if [ ! -f /etc/up.conf ]; then
        isPass=1
        errResult="INFO:Not found file:/etc/up.conf"  
        WRITE_XML_ERROR 0 ":${errResult}"    
    fi
    
    if [ ! -f ${DRV_DIR}/nxup ]; then
        isPass=1
        errResult="INFO:Not found file:${DRV_DIR}/nxup"  
        WRITE_XML_ERROR 0 ":${errResult}"    
    fi    
    
    if [ ! -f /usr/bin/upadm ]; then
        isPass=1
        errResult="INFO:Not found file:/usr/bin/upadm"  
        WRITE_XML_ERROR 0 ":${errResult}"    
    fi 
    
    if [ ${isPass} -eq 0 ]; then
        FILE_STATUS=`echo "#ls -l  /usr/bin/.upservice /etc/up.conf /kernel/drv/sparcv9/nxup /usr/bin/upadm";ls -l  /usr/bin/.upservice /etc/up.conf /kernel/drv/sparcv9/nxup /usr/bin/upadm`
        WRITE_XML_COMMON 0 ":${FILE_STATUS}"
    fi                
    
   
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}


HOST_04_ChkUpConfig()
{
    errResult=""
    isPass=0
    
    WRITE_XML_SUBCMD_HEADER $1

    if [ ${UltraPath_Flag}  -eq 1 ]; then
        PrintNotInstallUp
        return 1;
    fi
    
    cat /etc/system| awk "/^*nxup_driver_start$/,/^*nxup_driver_end$/"|sed 's/^[ \t]*//g'  |"${GREP}" -n  -v "^[ #]" > ${CMD_FILE}
    if [ $? -ne 0 ]; then
        isPass=1
        errResult="INFO:Not found UltraPath config in /etc/system"  
        WRITE_XML_ERROR 0 ":${errResult}" 
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0;   
    fi
        
    DRV_SD_ROW=`cat ${CMD_FILE}|${GREP} "forceload: drv/sd" |awk -F: '{print $1}'`
    if [ -z "${DRV_SD_ROW}" ]; then
        isPass=1
        errResult="INFO:Not found \"forceload: drv/sd\" in /etc/system"  
        WRITE_XML_ERROR 0 ":${errResult}" 
    fi
    
    DRV_SSD_ROW=`cat ${CMD_FILE}|${GREP} "forceload: drv/ssd" |awk -F: '{print $1}'`
    if [ -z "${DRV_SSD_ROW}" ]; then
        isPass=1
        errResult="INFO:Not found \"forceload: drv/ssd\" in /etc/system"  
        WRITE_XML_ERROR 0 ":${errResult}" 
    fi
    
    DRV_NXUP_ROW=`cat ${CMD_FILE}|${GREP} "forceload: drv/nxup" |awk -F: '{print $1}'`
    if [ -z "${DRV_NXUP_ROW}" ]; then
        isPass=1
        errResult="INFO:Not found \"forceload: drv/nxup\" in /etc/system"  
        WRITE_XML_ERROR 0 ":${errResult}" 
    fi
    
    if [ ${isPass} -ne 0 ]; then
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0;
    fi
    
    if [ ${DRV_SD_ROW} -ge ${DRV_NXUP_ROW} -o ${DRV_SSD_ROW} -ge ${DRV_NXUP_ROW} -o ${DRV_SD_ROW} -ge ${DRV_SSD_ROW} ];then
        isPass=1
        errResult="INFO: UltraPath config sequence error in /etc/system"  
        WRITE_XML_ERROR 0 ":${errResult}" 
        
        CONFIG_STATUS=`echo "#cat /etc/system |\"${GREP}\" -n -E -i \"drv/sd|drv/ssd|drv/nxup\"";cat /etc/system |"${GREP}" -n -E -i "drv/sd|drv/ssd|drv/nxup"`
        WRITE_XML_COMMON 0 ":${CONFIG_STATUS}"   
    fi
    
    if [ ${isPass} -eq 0 ]; then
        CONFIG_STATUS=`echo "#cat /etc/system |\"${GREP}\" -n -E -i \"drv/sd|drv/ssd|drv/nxup\"";cat /etc/system |"${GREP}" -n -E -i "drv/sd|drv/ssd|drv/nxup"`
        WRITE_XML_COMMON 0 ":${CONFIG_STATUS}"
    fi                
    
    
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}



HOST_05_ChkUpLogSpace()
{
    errResult=""
    isPass=0
    
    WRITE_XML_SUBCMD_HEADER $1

    if [ ${UltraPath_Flag}  -eq 1 ]; then
        PrintNotInstallUp
        return 1;
    fi
    
    if [ -d /opt/UltraPath/log/kernel_log ]; then
        LOG_SIZE=`du -sk /opt/UltraPath/log/kernel_log|awk '{print $1}'`
    
        if [ ${LOG_SIZE} -gt 204800 ]; then
            isPass=4
            errResult="INFO:UltraPath log dir larger than 200MB  "  
            WRITE_XML_ERROR 0 ":${errResult}"  
        fi
        
        LOG_SPACE=`echo "#du -sk /opt/UltraPath/log/kernel_log";du -sk /opt/UltraPath/log/kernel_log`
        WRITE_XML_COMMON 0 ":${LOG_SPACE}"
    else
        isPass=3
        WRITE_XML_COMMON 0 "No compress log directory"
    fi
   
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}

DISK_CHK_STR="KB|MB|GB|TB"

HOST_06_ChkUpDiskStatus()
{
    errResult=""
    isPass=0
    AppendStr=""
    
    WRITE_XML_SUBCMD_HEADER $1

    if [ ${UltraPath_Flag}  -eq 1 ]; then
        PrintNotInstallUp
        return 1;
    fi
    
    if [ ${Upadm_Flag}  -eq 1 ]; then
        PrintUpadmFileNotExist
        return 1;
    fi
    
    UP_VER=`pkgparam UltraPath VERSION|awk -F"." '{print $1 $2}'`
    
    if [ ${UP_VER} -ge 803 ]; then
        AppendStr=" type=all"
    fi
    
    upadm show vlun ${AppendStr}|${GREP} -E -i ${DISK_CHK_STR} > ${CMD_FILE}
    
    CHK_FLAG=`cat ${CMD_FILE}|wc -l`
    if [ ${CHK_FLAG} -eq 0 ]; then
        isPass=3
        errResult="Warning: Can't find any vluns in UltraPath"  
        WRITE_XML_ERROR 0 ":${errResult}"   
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0;
    fi

    abnormal=`cat ${CMD_FILE}|${GREP} -E -i "fault|degraded"|wc -l`
    
    if [ ${abnormal} -ne 0 ]; then
        isPass=1
        errResult="Warning: Some disks status abnormal"  
        WRITE_XML_ERROR 0 ":${errResult}"     
        DISK_INFO=`echo "#upadm show vlun ${AppendStr} |${GREP} -E -i \"fault|degraded\"|head -n 10";cat ${CMD_FILE}|${GREP} -E -i "fault|degraded"|head -n 10`
        
        if [ ${abnormal} -gt 10 ]; then
            DISK_INFO=`echo " ${DISK_INFO} \n ..........................."`
        fi
        
        WRITE_XML_ERROR 0 ":${DISK_INFO}"
    else
        DISK_INFO=`echo "#upadm show vlun ${AppendStr} |head -n 10";upadm show vlun ${AppendStr}|head -n 10`
        
        if [ ${CHK_FLAG} -gt 8 ]; then
            DISK_INFO=`echo " ${DISK_INFO} \n ..........................."`
        fi
        
        WRITE_XML_COMMON 0 ":${DISK_INFO}" 
    fi
    
    
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}

PATH_CHK_STR="fault|degraded|degradation"
HOST_07_ChkUpPathStatus()
{
    errResult=""
    isPass=0   
    
    
    WRITE_XML_SUBCMD_HEADER $1

    if [ ${UltraPath_Flag}  -eq 1 ]; then
        PrintNotInstallUp
        return 1;
    fi
    
    if [ ${Upadm_Flag}  -eq 1 ]; then
        PrintUpadmFileNotExist
        return 1;
    fi
    
    upadm show path |${GREP} FC > ${CMD_FILE}
    
    CHK_FLAG=`cat ${CMD_FILE}|wc -l`
    if [ ${CHK_FLAG} -eq 0 ]; then
        isPass=3
        errResult="Warning: Can't find any paths in UltraPath"  
        WRITE_XML_ERROR 0 ":${errResult}"   
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0;
    fi
    
    PATH_CHK=`cat ${CMD_FILE}|${GREP} -E -i "${PATH_CHK_STR}"|wc -l`
    
    if [ ${PATH_CHK} -ne 0 ]; then
        errResult="Warning: Some paths status abnormal." 
        WRITE_XML_ERROR 0 ":${errResult}"
        
        PATH_INFO=`echo "#upadm show path|${GREP} -E -i \"${PATH_CHK_STR}\"|head -n 10";cat ${CMD_FILE}|${GREP} -E -i "${PATH_CHK_STR}"|head -n 10`
        
        if [ ${PATH_CHK} -gt 10 ]; then
            PATH_INFO=`echo " ${PATH_INFO} \n ..........................."`
        fi
        
        WRITE_XML_ERROR 0 ":${PATH_INFO}"
        
        isPass=1
    else
        PATH_INFO=`echo "#upadm show path|head -n 10";upadm show path|head -n 10`
        
        if [ ${CHK_FLAG} -gt 8 ]; then
            PATH_INFO=`echo " ${PATH_INFO} \n ..........................."`
        fi
        
        WRITE_XML_COMMON 0 ":${PATH_INFO}"
    fi  
    
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}



HOST_08_ChkUpRedundancyController()
{
    errResult=""
    isPass=0
       
    
    WRITE_XML_SUBCMD_HEADER $1

    if [ ${UltraPath_Flag}  -eq 1 ]; then
        PrintNotInstallUp
        return 1;
    fi
    
    if [ ${Upadm_Flag}  -eq 1 ]; then
        PrintUpadmFileNotExist
        return 1;
    fi  
      
    upadm show vlun ${AppendStr}|${GREP} -E -i ${DISK_CHK_STR} > ${CMD_FILE}
    
    CHK_FLAG=`cat ${CMD_FILE}|wc -l`
    if [ ${CHK_FLAG} -eq 0 ]; then
        isPass=3
        errResult="Warning: Can't find any vluns in UltraPath"  
        WRITE_XML_ERROR 0 ":${errResult}"   
        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0;
    fi
    
    upadm show array  > ${CMD_FILE}
    
    ARRAY_ID=`cat ${CMD_FILE}| ${GREP}  -E '^[[:blank:]]*[[:digit:]]' | awk '{print $1}'`
    
    for i in ${ARRAY_ID}
    do
        upadm show array id=${i} > ${CMD_FILE}
        
        CTRL_STR=`cat ${CMD_FILE}|${GREP} -i "controller"|wc -l`
        
        if [ ${CTRL_STR} -eq 1 ]; then
            isPass=1
            errResult="Warning: Some arrays managed by UltraPath only connect single controller."  
            WRITE_XML_ERROR 0 ":${errResult}"   
            VLUN_INFO=`echo "#upadm show array id=${i}";cat ${CMD_FILE}`
            WRITE_XML_ERROR 0 ":${VLUN_INFO}"
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return 0;
        fi
        
        CTRL_STR=`cat ${CMD_FILE}|${GREP} -E -i "State|status"|${GREP} -E -i "normal|enable|degrad"|wc -l`
        
        if [ ${CTRL_STR} -lt 2 ]; then
            isPass=1
            errResult="Warning: Some controller status abnormal."  
            WRITE_XML_ERROR 0 ":${errResult}"   
            VLUN_INFO=`echo "#upadm show array id=${i}";cat ${CMD_FILE}`
            WRITE_XML_ERROR 0 ":${VLUN_INFO}"
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return 0;
        fi
    
    
    done 
    
    if [ ${isPass} -eq 0 ]; then
        PATH_INFO=`echo "#upadm show path";upadm show path`
        WRITE_XML_COMMON 0 ":${PATH_INFO}"
    fi
    
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}



HOST_09_ChkThirdMP()
{
    errResult=""
    isPass=0
    
    WRITE_XML_SUBCMD_HEADER $1

    if [ ${UltraPath_Flag}  -eq 1 ]; then
        PrintNotInstallUp
        return 1;
    fi
        
    pkginfo -l EMCpower  > /dev/null 2>&1
    
    if [ $? -eq 0 ]; then
        isPass=1
        WRITE_XML_COMMON 0 ":[thirdMP]:EMC powerpath installed"
    fi
    
        
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}



HOST_10_ChkOsVersion()
{
    errResult=""
    isPass=0
    
    OS_VER=`uname -r`
    
    WRITE_XML_SUBCMD_HEADER $1

    if [ ${UltraPath_Flag}  -eq 1 ]; then
        PrintNotInstallUp
        return 1;
    fi
        
    if [ ${OS_VER} != "5.11"  -o ${OS_VER} != "5.10" ]; then
       isPass=1
       errResult="Warning: The OS version is ${OS_VER}"  
       WRITE_XML_ERROR 0 ":${errResult}" 
    fi
    
    WRITE_XML_COMMON 0 ":[osversion]:${OS_VER} "
   
    
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}


HOST_11_ChkHcSingleDisk()
{
    errResult=""
    isPass=0
    
    WRITE_XML_SUBCMD_HEADER $1

    if [ ${UltraPath_Flag}  -eq 1 ]; then
        PrintNotInstallUp
        return 1;
    fi
    
    if [ ${Upadm_Flag}  -eq 1 ]; then
        PrintUpadmFileNotExist
        return 1;
    fi   
         
    upadm show vlun type=hypermetro |${GREP} -E -i ${DISK_CHK_STR} 2> /dev/null > ${CMD_FILE}
    
    CHK_FLAG=`cat ${CMD_FILE}|wc -l`
    if [ ${CHK_FLAG} -eq 0 ]; then

        isPass=3
        errResult="Not found hypermetro disk in UltraPath"  
        WRITE_XML_COMMON 0 ":[hypermetro]:${errResult}"   

        WRITE_XML_JUDGE $isPass
        WRITE_XML_SUBCMD_TAIL
        return 0;
    fi  
    
    VLUN_ID=`cat ${CMD_FILE}|awk '{print $1}'|sort|uniq`
    
    for i in ${VLUN_ID}
    do
        upadm show vlun id=${i} type=hypermetro > ${CMD_FILE}
        
        LUN_WWN_NUM=`cat ${CMD_FILE}|${GREP} "LUN WWN"|wc -l`
        if [ ${LUN_WWN_NUM} -ne 2 ]; then
            isPass=1
            errResult="Warning: vlun_id:${i} only one storage system reports the LUN in a HyperMetro pair."  
            WRITE_XML_ERROR 0 ":${errResult}"   
            
            VLUN_INFO=`echo "#upadm show vlun id=${i} type=hypermetro";cat ${CMD_FILE}`
            WRITE_XML_ERROR 0 ":${VLUN_INFO}"
            WRITE_XML_JUDGE $isPass
            WRITE_XML_SUBCMD_TAIL
            return 0;
        fi
    done
    
    VLUN_INFO=`echo "#upadm show vlun type=hypermetro|head -n 10";upadm show vlun type=hypermetro|head -n 10`
    
    if [ ${CHK_FLAG} -gt 8 ]; then
        VLUN_INFO=`echo " ${VLUN_INFO} \n ..........................."`
    fi
    
    WRITE_XML_COMMON 0 ":${VLUN_INFO}"  
    
    WRITE_XML_JUDGE $isPass
    WRITE_XML_SUBCMD_TAIL
    return 0;
}


HOST_UltraPathChkItem()
{
  

    WRITE_XML_CMD_HEADER $1
    
    case $1 in
        100)
        HOST_00_ChkUltraPathExist "0"        
        ;;
        101)
        HOST_01_ChkUltraPathVersion "0"
        ;;
        102)
        HOST_02_ChkUpServer "0"
        ;;
        103)
        HOST_03_ChkUpFiles "0" 
        ;;
        104)
        HOST_04_ChkUpConfig "0" 
        ;;
        105)
        HOST_05_ChkUpLogSpace "0"
        ;;
        106)
        HOST_06_ChkUpDiskStatus "0"
        ;;
        107)
        HOST_07_ChkUpPathStatus "0"
        ;;
        108)
        HOST_08_ChkUpRedundancyController "0"
        ;;
        109)
        HOST_09_ChkThirdMP "0"
        ;;
        110)
        HOST_10_ChkOsVersion "0"
        ;;
        111)        
        HOST_11_ChkHcSingleDisk "0"
        ;;
        *)
        echo "No this type"
        ;;
    esac

    WRITE_XML_CMD_TAIL         
}