#!/bin/sh 



G_SCRIPT_PATH=""
L_TMP=$0


G_SCRIPT_PATH=`echo "$L_TMP" |sed "s/inspect.sh//g"`

G_CHECK_RESULT_FILE=/tmp/check_result

if [ "${G_SCRIPT_PATH}" = "" ]; then

   G_SCRIPT_PATH=`pwd`
fi





OS=`uname -s`
HOSTNAME=`uname -n`

UltraPath_VERSION="NULL"
UltraPath_Flag=0
DISK_NUMBER="0"
PHY_PATH_NUM="0"
ARRAY_NUM="0"
Upadm_Flag=0

SCRIPTS=${G_SCRIPT_PATH}

LOCK=${G_SCRIPT_PATH}/.lock_${HOSTNAME}
PID=$$


cd ${G_SCRIPT_PATH} 1>/dev/null

if [ ${OS} = "AIX" ]
then
	OS_VER=`oslevel | cut -c1-3`
else
	OS_VER=`uname -r`
fi

GREP="/usr/bin/grep"

if [ ${OS} = "SunOS" ]; then
    GREP="/usr/xpg4/bin/grep"
elif [ ${OS} = "Linux" ]; then
    GREP="grep"
fi

. ${G_SCRIPT_PATH}/inspect_lib.sh


. ${SCRIPTS}/01_UltraPathChkItem.sh
. ${SCRIPTS}/02_OsMuiltPathChkItem.sh
. ${SCRIPTS}/03_HostSystemChkItem.sh


startup()
{
    if [ -f ${G_CHECK_RESULT_FILE} ]; then
        rm -f ${G_CHECK_RESULT_FILE}
    fi
    
    if [ -f ${LOCK} ]
    then
        PROC_ID=`cat ${LOCK} | cut -f2 -d":"`
        ps -p ${PROC_ID} > /dev/null 2>&1
        if [ $? -eq 0 ]
        then
	    	    # Check to see if process is called inspect
		
            PID_CMD=`ps -ef | awk '{ if($2=="'$PROC_ID'") print $9 }' |cut -c 3-11`
            if [ ${PID_CMD} = "inspect" ]
            then
                clear
                echo "inspect process (${PROC_ID}) is running"
                exit 12
            else
                rm -f ${LOCK}
            fi
        fi
    fi
	
    echo "${HOSTNAME}:${PID}:`date +%Y-%m-%d/%H.%M`" > ${LOCK}
}

cleanup()
{
    rm -f ${LOCK} > /dev/null 2>&1
    sleep 2
}

HOST_CheckBaseInfo ()
{

	
	#OS=`uname -s`
  #HOSTNAME=`uname -n`

  #UltraPath_VERSION="NULL"
  #OS_VER=`oslevel | cut -c1-3`
  #DISK_NUMBER="0"
  #PHY_PATH_NUM="0"
  #ARRAY_NUM="0"

	
	echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" >>${G_CHECK_RESULT_FILE}
	echo "<device>" >>${G_CHECK_RESULT_FILE}
	echo "	<sysinfo>" >>${G_CHECK_RESULT_FILE}
	
	echo "		<field name=\"hostname\">$HOSTNAME</field>" >>${G_CHECK_RESULT_FILE}
	echo "		<field name=\"OS type\">${OS}</field>" >>${G_CHECK_RESULT_FILE}
	echo "		<field name=\"UltraPath version\">${UltraPath_VERSION}</field>" >>${G_CHECK_RESULT_FILE}
	echo "		<field name=\"OS version\">${OS_VER}</field>" >>${G_CHECK_RESULT_FILE}
	echo "		<field name=\"hosttime\">`date`</field>" >>${G_CHECK_RESULT_FILE}
	       
  echo "		<field name=\"disknumber\">${DISK_NUMBER}</field>" >>${G_CHECK_RESULT_FILE}
  echo "		<field name=\"phypathnumber\">${PHY_PATH_NUM}</field>" >>${G_CHECK_RESULT_FILE}
  echo "		<field name=\"arraynumber\">${ARRAY_NUM}</field>" >>${G_CHECK_RESULT_FILE}
        
	echo "	</sysinfo>" >>${G_CHECK_RESULT_FILE}
	
	echo "</device>" >>${G_CHECK_RESULT_FILE}
}


#*********************************************************************************#
# Function: HOST_CheckAndExecCommand
# Description: Branch selection
# Input Parameters: $1
# $1: check item id, contain one or more parameters
#*********************************************************************************#
HOST_CheckAndExecCommand()
{
    while [ -n "$1" ]
    do
        check_item="$1"
        case $check_item in
            baseinfo)
                Host_CheckBaseInfo 
                ;;
            
            1*)
                HOST_UltraPathChkItem $check_item
                ;;
            2*)
                HOST_OsMuiltPathChkItem $check_item
                ;;
            3*)
                HOST_HostSystemChkItem $check_item
                ;;     
            *)
                echo "ERROR: check item is wrong."
                return 1
                ;;

        esac
        shift 1
    done
}

execWithTimeout()
{
    #timeout error code
    err_timeout=125
    #command to be executed
    command=$1
    #timeout for executing
    timeout=$2
    #checking interval
    interval=$3
    #delay for kill -SIGKILL
    delay=$4
    #execute command
    eval "${command} &"
    
    sub_pid=$!
    #check sub-process
    t=$timeout
    while [ ${t} -gt 0 ]; do
        kill -0 $sub_pid 2>/dev/null
        if [ $? -ne 0 ]; then
            #get exit code of sub-process
            wait $sub_pid
            return $?
        fi
        
        t=`expr $t - $interval`
        sleep $interval
    done
    #kill sub-process
    kill -15 $sub_pid 2>/dev/null && kill -0 $sub_pid 2>/dev/null || return $err_timeout
    sleep $delay
    kill -0 $sub_pid 2>/dev/null && kill -9 $sub_pid 2>/dev/null
    echo "sub proc exit==!!"
    return $err_timeout
}

#*********************************************************************************#
# Function: MAIN
# Description: main function
# Input Parameters: $*
# $*: all parameters
#*********************************************************************************#
MAIN()
{
    all_item="100 101 102 103 104 105 106 107 108 109 110 111 200 300 301 302"
    NORMAL=0
    case $1 in
        -c)
            shift 1
            HOST_CheckAndExecCommand $*
            ;;
        -o)
            shift 1
            HOST_CheckAndExecCommand $*
            ;;
        -all)
            if [ -n "$2" ] ; then
                echo "ERROR: Parameter error"
                return 1
            fi
            HOST_CheckAndExecCommand $all_item
            ;;
        *)
            echo "ERROR: Parameter error"
            return 1
            ;;
    esac
}

################ MAIN ################



startup

pkginfo | grep UltraPath > /dev/null 2>&1

if [ $? -ne 0 ]; then
    UltraPath_Flag=1
fi

if [ ! -f /usr/bin/upadm   ]; then
    Upadm_Flag=1
fi

WRITE_XML_HEADER

execWithTimeout "MAIN $*" 300 2 2 

if [ "$?" -eq 125 ];then        
   
    WRITE_XML_ERROR 0 "The item is over time and The result might not complete,Please check again!"
    WRITE_XML_JUDGE 1
    WRITE_XML_SUBCMD_TAIL
    WRITE_XML_CMD_TAIL
fi  

WRITE_XML_TAIL

cat $G_CHECK_RESULT_FILE    

cleanup

exit 0
