#!/usr/bin/expect

# 获取参数
set ip [lindex $argv 0]
set username [lindex $argv 1]
set password [lindex $argv 2]
set commands [lindex $argv 3]

# 设置超时时间
set timeout 20

# 开始连接
spawn ssh $username@$ip

# 处理首次连接时的key验证
expect {
    "yes/no" { send "yes\r"; exp_continue }
    "password:" { send "$password\r" }
}

# 逐条执行指令
set cmd_list [split $commands ";"]
foreach cmd $cmd_list {
    send "$cmd\r"
    expect {
        ">" { }
        "]" { }
    }
}
