# -*- coding: UTF-8 -*-
import traceback
import re


def getProVersion(cli):
    cliRet = cli.execCmd("show system general")
    
    cliRetList = cliRet.splitlines()
    ProVersion = None
    if re.search("System Name", cliRet, re.IGNORECASE):
        #获取产品型号
        for line in cliRetList:
            if re.search("Product Version", line, re.IGNORECASE):
                ProVersion = (line.split(":")[1]).strip()
    return ProVersion


def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showrespool")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        chkSas_start = False
        lang = py_java_env.get("lang")
        errMsg = ""
        linkupNumA = 0
        linkupNumB = 0
        #Optimize check rate
        cliRet = "default"
        cliRet = py_java_env.get("showPortGeneral")
        if cliRet == None or cliRet == "default":
            PY_LOGGER.info("Sequence[14] execute command: \"show port general\".")
            cliRet = cli.execCmd("show port general")
            py_java_env.put("showPortGeneral", cliRet)
        PY_LOGGER.info("\nSequence[14] execute command result:\n" + cliRet)
        
        #用于判断“Error”是否在各个端口外
        isErrorOutOfPort = True
        
        list = cliRet.splitlines()
        for field in list:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[14] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg)
            if field.find("SAS port") != -1:
                chkSas_start = True
                isErrorOutOfPort = False
            if field.find("FC port") != -1 or field.find("COM port") != -1 or field.find("PCIE port") != -1 \
                or field.find("ETH port") != -1 or field.find("FCoE port") != -1:
                chkSas_start = False
                isErrorOutOfPort = False
            if chkSas_start == True:
                if re.search('Error:', field, re.IGNORECASE):
                    flag = False
                    if "zh" == lang:
                        errMsg += u"\nSAS端口检查异常。"
                    else:
                        errMsg += "\nSAS port is abnormal."
                         
                    PY_LOGGER.info("SAS port is abnormal.")
                    return (flag, cliRet, errMsg)
                
                #有效判断行里一定含有“Expansion Port”
                if -1!=field.find(" Expansion Port "):
                    list2 = field.split()
                    
                    #health status状态要为normal
                    if list2[1] != "Normal" :
                        flag = False
                        if "zh" == lang:
                            errMsg += u"\nSAS端口（"+list2[0]+u"）健康状态检查异常"
                        else:
                            errMsg += "\nThe health status of SAS port("+list2[0]+") is abnormal"
                        continue
                    
                    
                    #link up时A，B控个数要相等，且速率要为6G或12G，区设备版本号，若V2R2C10则6G，若V3R1C00则12G
                    if list2[1] == "Normal" and list2[3] == "Up":
                        if -1 != list2[0].find(".A"):
                            linkupNumA +=1
                        if  -1 != list2[0].find(".B"):
                            linkupNumB +=1
                        
                        
                        ProVersion = getProVersion(cli)
                        isSpeed = False
                        if ProVersion == "V300R001C00":
                            if -1 == field.find(" 12000 "):
                                isSpeed = True
                        else:
                            if -1 == field.find(" 6000 "):
                                isSpeed = True
                                
                        if True == isSpeed:
                            flag = False
                            if "zh" == lang:
                                errMsg += u"\nSAS端口（"+list2[0]+u"）速率异常"
                            else:
                                errMsg += "\nThe speed of SAS port("+list2[0]+") is abnormal"
                            
                    
        if linkupNumA != linkupNumB:
            flag = False
            if "zh" == lang:
                errMsg += u"\nSAS线缆连接不对称，A和B端口link up数量要相等"
            else:
                errMsg += "\nThe link up of SAS port is not symmetrical, the link up number of port A and port B must be equaled"
        
        #如果“Error”出现在命令的6个端口外，比如命令超时，就不会打印那6个端口信息
        if True == isErrorOutOfPort:
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", cliRet, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[14]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
        return (flag, cliRet, errMsg)
                                   
    except Exception, exception:
        PY_LOGGER.error("Sequence[14] catch except of when check FC port."+str(chkSas_start)+"~~~~over!")
        PY_LOGGER.error("Sequence[14] catch except of check disk NCQ status.")
        PY_LOGGER.error("Sequence[14] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[14] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[14] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
