# -*- coding: UTF-8 -*-
import traceback
import re
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showsnapshot")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        chkfc_start = False
        find_flag = False
        lang = py_java_env.get("lang")
        errMsg = ""
        #Optimize check rate
        cliRet = "default"
        cliRet = py_java_env.get("showPortGeneral")
        if cliRet == None or cliRet == "default":
            PY_LOGGER.info("Sequence[15] execute command: \"show port general\".")
            cliRet = cli.execCmd("show port general")
            py_java_env.put("showPortGeneral", cliRet)
        PY_LOGGER.info("\nSequence[15] execute command result:\n" + cliRet)
        
        #用于判断“Error”是否在各个端口外
        isErrorOutOfPort = True
        isThreePortExist = (cliRet.find("Host Port:--") == -1 and cliRet.find("Management Port:--") == -1 \
                and cliRet.find("Maintenance Port:--") == -1)
        
        list = cliRet.splitlines()
        for field in list:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[15] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg)
            
            if field.find("ETH port") != -1:
                chkfc_start = True
                isErrorOutOfPort = False
            if field.find("FC port") != -1 or field.find("COM port") != -1 or field.find("SAS port") != -1 \
                or field.find("PCIE port") != -1 or field.find("FCoE port") != -1:
                chkfc_start = False
                isErrorOutOfPort = False
            if chkfc_start == True:
                
                #如果三个ETH port中的那三个端口都没有找到，就进入异常分支
                if True == isThreePortExist:
                    #其它出现“Error:”字眼的信息视为不通过
                    if re.search("Error:", field, re.IGNORECASE):
                        flag = False
                        PY_LOGGER.info("There is an error in Sequence[15]!")
                        if "zh" == lang:
                            errMsg = u"\n获取ISCSI端口信息出错。"
                        else:
                            errMsg = "\nThere is an error in getting ISCSI port information."
                        return (flag, cliRet, errMsg)
                else:
                    #业务网口type 里面必然会有 Host Port
                    if not re.search("Host Port", field,re.IGNORECASE) or -1 != field.find("------------"):
                        continue
                    
                    list2 = field.split()
                    
                    if "Normal"!=list2[1]:
                        flag = False
                        if "zh" == lang:
                            errMsg += u"\nISCSI端口["+list2[0]+u"]健康状态检查异常。"
                        else:
                            errMsg += "\nThe health status of ISCSI port ["+list2[0]+"] is abnormal." 
                        continue
                    
                    if list2[1] == "Normal" and list2[3] == "Up":
                        if list2[len(list2)-1] not in ["10", "100", "1000", "10000"]:
                            flag = False
                            if "zh" == lang:
                                errMsg += u"\nISCSI端口["+list2[0]+u"]速率异常。"
                            else:
                                errMsg += "\nThe speed of iscsi port["+list2[0]+"] is abnormal."

        if not flag:
             PY_LOGGER.info("Sequence[15] inspect not pass.")
             
        #如果“Error”出现在命令的6个端口外，比如命令超时，就不会打印那6个端口信息
        if True == isErrorOutOfPort:
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", cliRet, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[15]!")
                if "zh" == lang:
                    errMsg = u"\n获取CLI信息失败"
                else:
                    errMsg = "\nThere is an error in getting CLI information."
                return (flag, cliRet, errMsg)
             
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        PY_LOGGER.error("Sequence[15] catch except of when check ETH port.")
        PY_LOGGER.error("Sequence[15] catch except of check ETH port.")
        PY_LOGGER.error("Sequence[15] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[15] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[15] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
