# -*- coding: UTF-8 -*-
import traceback
import re
MAX_RETRYS = 5

#Change to cli model, make sure the next item exec successful
def change2cli(cli):
    index =0 
    cliRet = cli.execCmdNoLog("show system general")
    
    #密码输入错误时及正常情况从developer模式下退出
    if -1 != cliRet.find("Password") or -1 != cliRet.find("developer:/>"):
        cliRet = cli.execCmd("exit")
        PY_LOGGER.info("Sequence[19] change to cli model")
        while(-1 == cliRet.find(":/>")):
            index+=1
            cliRet = cli.execCmd("exit")
            if -1!=cliRet.find("Are you sure to exit?(y/n):"):
                cliRet = cli.execCmd("n")
            if index>MAX_RETRYS:
                break
        
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showrmtlink")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        chk_start =False
        lang = py_java_env.get("lang")
        errMsg = ""
        type = "default"
        inDeveloper = False
        cliRet = str(cli.execCmd("change user_mode current_mode user_mode=developer"))
        password = str(py_java_env.get("devPwd").get("developer"))
        if(None == password or ""== password):
            PY_LOGGER.info("The password is NULL, out!")
            flag = False
            change2cli(cli)
            if "zh" == lang:
                errMsg = u"\n获取developer密码为空，请确定是否已配置密码"
            else:
                errMsg = "\nGet the password of developer is null, make sure to configure it right"
            return (flag, cliRet, errMsg)
        cliRet += cli.execCmdNoLog(password)
        
        if cliRet.find("developer:/>") == -1:
            flag = False
            PY_LOGGER.info("Sequence[19] can not access develoer mode")
            change2cli(cli)
            if "zh" == lang:
                if cliRet.find("Password is wrong") != -1 or -1!=cliRet.find("Password:"):
                    errMsg = u"\ndeveloper密码配置错误"
                else:
                    errMsg = u"\n系统不能进入developer模式，请确认系统处于admin模式"
            else:
                if cliRet.find("Password is wrong") != -1 or -1!=cliRet.find("Password:"):
                    errMsg = "\nThe password of developer is wrong"
                else:
                    errMsg = "\nIt failed to access the developer mode, please confirm system in admin mode"
            return (flag, cliRet, errMsg)
        inDeveloper = True

        cliRet = cli.execCmd("show port bit_error")
        PY_LOGGER.info("\nSequence[19] execute command result:\n" + cliRet)
        
        list = cliRet.splitlines()
        for field in list:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                if inDeveloper == True:
                    change2cli(cli)
                    inDeveloper = False
                flag = False
                PY_LOGGER.info("Sequence[19] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg)
            
            if field.find("SAS port") != -1:
                chk_start = True
                PY_LOGGER.info("Sequence[19] change flag to true~~~over!"+field)
            if field.find("ETH port") != -1 or field.find("FC port") != -1 or field.find("FCoE port")!= -1 or field.find("PCIE port")!= -1 :
                chk_start = False
                PY_LOGGER.info("Sequence[19] change flag to false~~~over!"+field)
            if chk_start == True:
                #其它出现“Error:”字眼并且不包含ID的信息视为不通过
                if re.search("Error:", field, re.IGNORECASE) and not re.search("ID", field, re.IGNORECASE):
                    if inDeveloper == True:
                        change2cli(cli)
                        inDeveloper = False
                    flag = False
                    PY_LOGGER.info("There is an error in Sequence[19]!")
                    if "zh" == lang:
                        errMsg = u"\n获取信息出错。"
                    else:
                        errMsg = "\nThere is an error in getting information."
                    return (flag, cliRet, errMsg)
                if field.find("Start Time") != -1:
                    continue
                list2 = field.split()
                if len(list2) < 6:
                    continue
                if field.find("---") != -1:
                    continue
                if list2[1] !='0' or list2[2] != '0' or list2[3] !='0' or list2[4] != '0':
                    flag = False
                    if inDeveloper == True:
                        change2cli(cli)
                        inDeveloper = False
                    if "zh" == lang:
                        errMsg = errMsg + u"\nSAS口("+list2[0]+u")存在误码"
                    else:
                        errMsg = errMsg + "\nThe SAS port("+list2[0]+") exist error bits"

        if inDeveloper == True:
            change2cli(cli)
            inDeveloper = False
        return (flag, cliRet, errMsg)
                
    except Exception, exception:
        PY_LOGGER.error("Sequence[19] catch except of check host port error.")
        PY_LOGGER.error("Sequence[19] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[19] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[19] catch except of trace back:" + str(traceback.print_exc()))
        if inDeveloper == True:
            change2cli(cli)
            inDeveloper = False
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
