# -*- coding: UTF-8 -*-
import traceback
import re
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showexpmodule")
    Return             : the checkitem is pass;cli source info
    """
    try:
    	flag = True
    	lang = py_java_env.get("lang")
    	errMsg = ""
    	cliRet = cli.execCmd("show enclosure")
    	PY_LOGGER.info("\nSequence[21] execute command result:\n" + cliRet)
    	
    	list = cliRet.splitlines()
    	for field in list:
            
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[21] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[21]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
            if field.find("Data Switch") != -1:
                list2 = field.split()
                frameId = int(list2[0])
                if list2[3] != "Normal":
                    flag = False
                    PY_LOGGER.info("Sequence[21] Health Status is:"+list2[3]+".~~~over!")
                    if "zh" == lang:
                        errMsg = u"\n交换机("+frameId+u")健康状态异常("+list2[3]+u")"
                    else:
                        errMsg = "\nThe health status of system is abnormal("+list2[3]+")"
                    return (flag, cliRet, errMsg)
                if list2[4] != "Online":
                    flag = False
                    PY_LOGGER.info("Sequence[21] Running Status is:"+list2[4]+".~~~over!")
                    if "zh" == lang:
                        errMsg = u"\n交换机("+frameId+u")运行状态检查异常("+list2[4]+u")"
                    else:
                        errMsg = "\nThe running status of system is abnormal("+list2[4]+")"
                    return (flag, cliRet, errMsg)
    	return (flag, cliRet)

    except Exception, exception:
        PY_LOGGER.error("Sequence[21] catch except of check enclosure status.")
        PY_LOGGER.error("Sequence[21] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[21] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[21] catch except of trace back:" + str(traceback.print_exc()))
        falg = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
