# -*- coding: UTF-8 -*-
import traceback
import re
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("show system general")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        errMsg = ""
        cliRet = cli.execCmd("show disk routine_test")
        PY_LOGGER.info("\nSequence[28] execute command result:\n" + cliRet)
        
        list = cliRet.splitlines()
        
        for field in list:
            line = field
            field = field.replace(" ","")
            
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[28] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[28]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
            if field.startswith("EnableRoutineTest"):
                if field.replace("EnableRoutineTest:","") != "On":
                    flag = False
                    if "zh" == lang:
                        errMsg += u"\n硬盘例测周期状态不正常（" + line.strip() + u"）"
                    else:
                        errMsg += "\nDisk's routine test is abnormal(" + line.strip() + ")"
                    
            if field.startswith("RoutineTestPeriod"):
                val4RoutineTestPeriod = field.replace("RoutineTestPeriod:","")
                if val4RoutineTestPeriod == "--" or val4RoutineTestPeriod == "" or int(val4RoutineTestPeriod.replace("Minute", "")) < 1:
                    flag = False
                    if "zh" == lang:
                        errMsg += u"\n硬盘例测周期状态不正常（" + line.strip() + u"）"
                    else:
                        errMsg += "\nDisk's routine test is abnormal(" + line.strip() + ")"
                
        return (flag, cliRet, errMsg)

    except Exception, exception:
        PY_LOGGER.error("Sequence[28] catch except of check controller status.")
        PY_LOGGER.error("Sequence[28] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[28] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[28] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
            
        return (flag, cliRet, errMsg)
