# -*- coding: UTF-8 -*-
import traceback
import re
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("showpower")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        i = 0
        lang = py_java_env.get("lang")
    	errMsg = ""
        cliRet = cli.execCmd("show power_supply")
        PY_LOGGER.info("\nSequence[3] execute command result:\n" + cliRet)
        
        list = cliRet.splitlines()
        for field in list:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[3] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[3]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
            i = i + 1
            if i >= 5:
                list2 = field.split()
                if len(list2) < 4:
                    continue
                if -1==field.find("Normal") or -1==field.find("Online"): 
                    flag = False
                    PY_LOGGER.info("\nSequence[3] inspect not pass.")
                    if "zh" == lang:
                        errMsg += u"\n电源ID[" + list2[0] + u"]状态检测异常"
                    else:
                        errMsg += "\nThe status of power supply[" + list2[0] + "] is abnormal"

        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        PY_LOGGER.error("Sequence[3] catch except of check power_supply.")
        PY_LOGGER.error("Sequence[3] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[3] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[3] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
