# -*- coding: UTF-8 -*-
import traceback
import re
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : check product version
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("show system general")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = False
        lang = py_java_env.get("lang")
        errMsg = ""
        #Optimize check rate
        cliRet = py_java_env.get("showSystemGeneral")
        if None == cliRet:
            cliRet = cli.execCmd("show system general")
            py_java_env.put("showSystemGeneral", cliRet)
        PY_LOGGER.info("\nSequence[41] execute command result:\n" + cliRet)
        
        list = cliRet.splitlines()
        for field in list:
            field = field.replace(" ", "")
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[41] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[41]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
            if field.startswith("ProductVersion"):
                #兼容V3
                productVersion = field.replace("ProductVersion:", "")
                if productVersion.find("V200R002C10") != -1 or productVersion.find("V300R001C00") != -1:
                    flag = True
                    return (flag, cliRet)
                else:
                    PY_LOGGER.info("Sequence[41] Inspect product version is: " + field)
                    
        if "zh" == lang:
            errMsg = u"\n系统版本异常"
        else:
            errMsg = "\nThe version of system is not correct"
        return (flag, cliRet, errMsg)

    except Exception, exception:
        PY_LOGGER.error("Sequence[41] catch except of check product version.")
        PY_LOGGER.error("Sequence[41] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[41] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[41] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
