# -*- coding: UTF-8 -*-
import traceback
import re
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : check BBU version
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("show version all")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        #Optimize check rate
        cliRet = "default"
        lang = py_java_env.get("lang")
    	errMsg = ""
        cliRet = py_java_env.get("showVersionAll")
        if cliRet == None or cliRet == "default":
            PY_LOGGER.info("Sequence[48] execute command: \"show version all\".")
            cliRet = cli.execCmd("show version all")
            py_java_env.put("showVersionAll", cliRet)
        PY_LOGGER.info("\nSequence[48] execute command result:\n" + cliRet)

        #Check BBU version
        list = cliRet.splitlines()
        versionTrace = []
        startFalg = False
        for field in list:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[48] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[48]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
            if field.startswith("BBU:"):
                startFalg = True

            if startFalg:
                if -1 != field.find("----") or -1 != field.find(" ID "):
                    continue
             
                list = field.split()
                if(len(list) == 2):
                    versionTrace.append(list[1])
 
        bbuVersionSort = sorted(versionTrace)   
        
        #判断BBU版本是否一致
        if 0 != len(bbuVersionSort):
            if (bbuVersionSort[0]!=bbuVersionSort[-1]):
                flag = False 
                versionDisplay = ""
                for version in versionTrace:
                    if "zh" == lang:
                        versionDisplay +=version+u"，"
                    else:
                        versionDisplay +=version+u","
                versionDisplay = versionDisplay[:-1]
                
                if "zh" == lang:
                    errMsg += u"\nBBU版本不一致：" + versionDisplay
                else:
                    errMsg += "\nThe version of BBU is different: " + versionDisplay
        
        return (flag, cliRet, errMsg)
            
    except Exception, exception:
        PY_LOGGER.error("Sequence[48] catch except of check BBU version.")
        PY_LOGGER.error("Sequence[48] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[48] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[48] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)

