# -*- coding: UTF-8 -*-
import traceback
import re
MAX_RETRYS = 5

def getBBUNumDict(cli):
    ctrlNum = 0
    bbuNumDict = {}
    cliRet = cli.execCmd("show controller general")
    list = cliRet.splitlines()

    for field in list:
        field = field.replace(" ","")
        if field.startswith("Controller:"):
            ctrlNum = ctrlNum + 1
            continue
    # 控控制器BBU标准规格    
    if ctrlNum <= 2:
        bbuNumDict = {"S2600T":2, "S5500T":2, "S5600T":4, "S5800T":4, "S6800T":4 , "5600 V3":2, "5800 V3":3, "6800 V3":4, "6900 V3":4}     
    else:
        bbuNumDict = {"S5600T":8, "S5800T":8, "S6800T":8,"5600 V3":2, "5800 V3":3, "6800 V3":4, "6900 V3":4}
    return bbuNumDict  

#####################################################
# 函数名称：checkBbuNum
# 功能说明：检测BBU个数是否达标
# 传入参数：cli连接，通过标识flag，错误信息errMsg，BBU状态回文cliRet4Bbu
# 返 回  值：通过标识flag，错误信息errMsg，回显结果cliRet
#####################################################
def checkBbuNum(cli, flag, errMsg, cliRet4Bbu):
    bbuNumDict = {} 
    cliRet4SysInfo = cli.execCmd("show system general")
    PY_LOGGER.info("\nSequence[5] execute command result for system:\n" + cliRet4SysInfo)
    cliRet4SysInfoList = cliRet4SysInfo.splitlines()
    lang = py_java_env.get("lang")
    pdtModel = ""
    #能查询到系统信息
    if re.search("System Name", cliRet4SysInfo, re.IGNORECASE):
        #获取产品型号
        for line in cliRet4SysInfoList:
            if re.search("Product Model", line, re.IGNORECASE):
                pdtModel = (line.split(":")[1]).strip()
                break
    else:
        for line in cliRet4SysInfoList:
            #系统没有运行在admin模式
            if line.startswith("-bash") or line.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[5] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet4SysInfo, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", line, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[5]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet4SysInfo, errMsg)
            
    #无法获取产品型号
    if "" == pdtModel:
        flag = False
        PY_LOGGER.info("Sequence[5] cannot get product model.")
        if "zh" == lang:
            errMsg += u"\n无法获取产品型号。"
        else:
            errMsg += "\nCannot get product model."
    else:
        #根据产品型号获取标准BBU个数
        standardBbuNum = 0
        bbuNumDict = getBBUNumDict(cli)
        if bbuNumDict.has_key(pdtModel):
            standardBbuNum = bbuNumDict[pdtModel]
        
        #获取真实BBU个数
        cliRet4BbuList = cliRet4Bbu.splitlines()
        count4Bbu = 0
        isCounterSwitchOn = False
        for line in cliRet4BbuList:
            #如果找到列分隔符"---"，就打开计数开关，并在下一行开始计数
            if re.search("---", line, re.IGNORECASE):
                isCounterSwitchOn = True
                continue
            #如果找到“:/>”，就关闭计数开关，并退出循环
            if re.search(":/>", line, re.IGNORECASE):
                isCounterSwitchOn = False
                break
            #如果是空行，则不计数
            if "" == line.strip():
                continue
            #如果计数开关打开，则开始计数
            if isCounterSwitchOn:
                count4Bbu += 1
        
        #比较真实BBU个数和标准BBU个数是否一致
        if count4Bbu < standardBbuNum:
            flag = False
            PY_LOGGER.info("Sequence[5] BBU number is not enough.")
            if "zh" == lang:
                errMsg += u"\nBBU个数不足。"
            else:
                errMsg += "\nBBU number is not enough."
    return (flag, cliRet4SysInfo, errMsg)

#Change to cli model, make sure the next item exec successful
def change2cli(cli):
    index =0 
    cliRet = cli.execCmdNoLog("show system general")
    
    #密码输入错误时及正常情况从developer模式下退出
    if -1 != cliRet.find("Password") or -1 != cliRet.find("developer:/>"):
        cliRet = cli.execCmd("exit")
        PY_LOGGER.info("Sequence[5] change to cli model")
        while(-1 == cliRet.find(":/>")):
            index+=1
            cliRet = cli.execCmd("exit")
            if -1!=cliRet.find("Are you sure to exit?(y/n):"):
                cliRet = cli.execCmd("n")
            if index>MAX_RETRYS:
                break
        
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet4Bbu = cli.execCmd("showbbu")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        i = 0
        inDeveloper = False
        lang = py_java_env.get("lang")
        errMsg = ""
        cliRet4Bbu = cli.execCmd("change user_mode current_mode user_mode=developer")
        password = str(py_java_env.get("devPwd").get("developer"))
        if(None == password or ""== password):
            PY_LOGGER.info("Sequence[5] password is NULL, out!")
            flag = False
            change2cli(cli)
            if "zh" == lang:
                errMsg = u"\n获取developer密码为空，请确定是否已配置密码"
            else:
                errMsg = "\nGet the password of developer is null, make sure to configure it right"
            return (flag, cliRet4Bbu, errMsg)
        cliRet4Bbu += cli.execCmdNoLog(password)

        if cliRet4Bbu.find("developer:/>") == -1:
            flag = False
            PY_LOGGER.info("Sequence[5] can not access develoer mode")
            change2cli(cli)
            if "zh" == lang:
                if cliRet4Bbu.find("Password is wrong") != -1:
                    errMsg = u"\ndeveloper密码配置错误"
                else:
                    errMsg = u"\n系统不能进入developer模式，请确认系统处于admin模式"
            else:
                if cliRet4Bbu.find("Password is wrong") != -1:
                    errMsg = "\nThe password of developer is wrong"
                else:
                    errMsg = "\nIt failed to access the developer mode, please confirm system in admin mode"
            return (flag, cliRet4Bbu, errMsg)
        inDeveloper = True

        cliRet4Bbu = cli.execCmd("show bbu life")
        PY_LOGGER.info("\nSequence[5] execute command result:\n" + cliRet4Bbu)
        
        #不能查到BBU寿命信息
        if not (re.search("ID", cliRet4Bbu, re.IGNORECASE) and \
                re.search("Remaining Lifetime", cliRet4Bbu, re.IGNORECASE)):
            cliRet4BbuList = cliRet4Bbu.splitlines()
            for line in cliRet4BbuList:
                #系统不在admin模式
                if line.startswith("-bash") or line.startswith("upgrade"):
                    if inDeveloper == True:
                        change2cli(cli)
                        inDeveloper = False
                    flag = False
                    PY_LOGGER.info("Sequence[5] not in admin mode, out!")
                    if "zh" == lang:
                        errMsg = u"\n系统没有运行在admin模式"
                    else:
                        errMsg = "\nSystem is not in admin Mode"
                    return (flag, cliRet4Bbu, errMsg)
                #其它出现“Error:”字眼的信息视为不通过
                if re.search("Error:", line, re.IGNORECASE):
                    if inDeveloper == True:
                        change2cli(cli)
                        inDeveloper = False
                    flag = False
                    PY_LOGGER.info("There is an error in Sequence[5]!")
                    if "zh" == lang:
                        errMsg = u"\n获取信息出错。"
                    else:
                        errMsg = "\nThere is an error in getting information."
                    return (flag, cliRet4Bbu, errMsg)
                #BBU不在位
                if line.startswith("Command executed successfully."):
                    flag = False
                    PY_LOGGER.info("Sequence[5] BBU does not exist!")
                    if "zh" == lang:
                        errMsg = u"\nBBU不在位。"
                    else:
                        errMsg = "\nBBU does not exist."
                    return (flag, cliRet4Bbu, errMsg)
        else:
            #检测BBU个数是否达标
            retTuple = checkBbuNum(cli, flag, errMsg, cliRet4Bbu)
            flag = retTuple[0]
            cliRet4SysInfo = retTuple[1]
            errMsg = retTuple[2]
            
            #检测BBU寿命
            cliRet4BbuList = cliRet4Bbu.splitlines()
            for line in cliRet4BbuList:
                i = i + 1
                if i >= 5:
                    list2 = line.split()
                    if len(list2) != 2:
                        continue
                    bbuId = list2[0]
                    if int(list2[1]) < 60:
                        flag = False
                        if inDeveloper == True:
                            change2cli(cli)
                            inDeveloper = False
                        if "zh" == lang:
                            errMsg += u"\nBBU(" + bbuId + u")生命剩余时间小于60天"
                        else:
                            errMsg += "\nThe remain life of BBU(" + bbuId + ") less than 60 days"
                        return (flag, cliRet4Bbu, errMsg)
                    
            if inDeveloper == True:
                change2cli(cli)
                inDeveloper = False
            return (flag, cliRet4Bbu + cliRet4SysInfo, errMsg)
    except Exception, exception:
        PY_LOGGER.error("Sequence[5] catch except of check bbu life.")
        PY_LOGGER.error("Sequence[5] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[5] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[5] catch except of trace back:" + str(traceback.print_exc()))
        if inDeveloper == True:
            change2cli(cli)
            inDeveloper = False
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet4Bbu + cliRet4SysInfo, errMsg)
