# -*- coding: UTF-8 -*-
import traceback
import re
def execute(cli):
    """
    Create date        : 2012/05/18, Midify date:2012/06/12
    Function name      : execute(cliConnection)
    Function describe  : check LUN status
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("show lun")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
    	errMsg = ""
        #Optimize check rate, use filter
        filterCmd = "|filterRow column=Health\sStatus predict=not predict2=equal_to value=Normal logicOp=or column=Running\sStatus predict=not predict2=equal_to value=Online"
        cliRet = cli.execCmd("show lun general " + filterCmd)
        PY_LOGGER.info("\nSequence[61] execute command result:\n" + cliRet)
        
        list = cliRet.splitlines()
        i = 0
        for field in list:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[61] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[61]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            i = i+1
            
            #If more than 3 lines its means have fault or offline LUN
            if i > 3:
                flag = False
                if "zh" == lang:
                    errMsg = u"\nLun状态异常"
                else:
                    errMsg = "\nThe status of lun exists faults"
                return (flag, cliRet, errMsg)
        return (flag, cliRet)
    
    except Exception, exception:
        PY_LOGGER.error("Sequence[61] catch except of check LUN status.")
        PY_LOGGER.error("Sequence[61] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[61] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[61] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
