# -*- coding: UTF-8 -*-
import traceback
import re

#################################################################
# 函数名称：getColValue
# 功能说明：根据列号获取列值
# 传入参数：字符串line，列号colNum
# 返 回  值：健康状态列值
#################################################################
def getColValue(line, colNum):
    colValue = ""
    colList = line.split("  ")
    count = 0
    for tempCol in colList:
        if "" != tempCol:
            count += 1
            if colNum == count:
                colValue = tempCol.strip()
                break
    return colValue

def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : check POOL status
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("show storage_pool general")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
    	errMsg = ""
        cliRet = cli.execCmd("show storage_pool general")
        PY_LOGGER.info("\nSequence[62] execute command result:\n" + cliRet)
        list = cliRet.splitlines()
        i = 0
        for field in list:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[62] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[62]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            i = i+1
            if i > 4:
                list1 = field.split()
                if(-1 != list1[0].find(":/>")):
                    break
                id = getColValue(field, 1)
                healthStatus = getColValue(field, 4)
                runningStatus = getColValue(field, 5)
                if ("Normal" != healthStatus):
                    flag = False
                    PY_LOGGER.info("Sequence[62] inspect lun status is:" + healthStatus)
                    if "zh" == lang:
                        errMsg += u"\nPool（" + id + u"）健康状态异常（" + healthStatus + u"）"
                    else:
                        errMsg += "\nThe health status of pool(" + id + ") is abnormal(" + healthStatus + ")"
                
                if runningStatus not in ["Online", "Balancing"]:
                    flag = False
                    PY_LOGGER.info("Sequence[62] inspect lun running status is:" + runningStatus)
                    if "zh" == lang:
                        errMsg += u"\nPool（" + id + u"）运行状态异常（" + runningStatus + u"）"
                    else:
                        errMsg += "\nThe running status of pool(" + id + ") is abnormal(" + runningStatus + ")"
        return(flag, cliRet, errMsg)
    
    except Exception, exception:
        PY_LOGGER.error("Sequence[62] catch except of check POOL status.")
        PY_LOGGER.error("Sequence[62] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[62] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[62] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
