# -*- coding: UTF-8 -*-
import traceback
import re
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : check extent status
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("show storage_pool general")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
    	errMsg = ""
        cliRet1 = cli.execCmd("show storage_pool general")
        PY_LOGGER.info("\nSequence[64] execute command result:\n" + cliRet1)
        
        cliRet = ""
        list = cliRet1.splitlines()
        i = 0
        for field1 in list:
            #Need enter to CLI and must in normal mode.
            if field1.startswith("-bash") or field1.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[65] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field1, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[65]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
            i = i+1
            if i > 4:
                list1 = field1.split()

                #Find to the end
                if(-1 != list1[0].find(":/>")):
                    break

                #Find right lines and show each POOL_ID
                if(len(list1) >= 6):
                    cliRet2 = cli.execCmd("show storage_pool general pool_id=" + str(list1[0]))
                    cliRet = cliRet + cliRet2
                    PY_LOGGER.info("Sequence[65] show storage_pool general ID is:" + str(list1[0]))
                    listTier = cliRet2.splitlines()

                    #Extent status equal to Ready, relocating and pause
                    for field2 in listTier:
                        extentStatus = "default"
                        field2 = field2.replace(" ", "")
                        if field2.startswith("RelocationStatus:"):
                            extentStatus = field2.replace("RelocationStatus:", "")
                            if (extentStatus == "Ready") or (extentStatus == "Relocating") or (extentStatus == "Paused"):
                                PY_LOGGER.info("Sequence[65] check extent status is:" + str(extentStatus))
                                flag = True
                                break
                            else:
                                flag = False
                                PY_LOGGER.info("Sequence[65] check extent status is wrong:" + str(extentStatus))
                                if "zh" == lang:
                                    errMsg = u"\nPool("+list1[0]+u")的迁移状态异常("+extentStatus+u")"
                                else:
                                    errMsg = "\nThe relocation status of pool("+list1[0]+") is abnormal("+extentStatus+")"
                                return(flag, cliRet1 + cliRet, errMsg)
                            
        return(flag, cliRet1 + cliRet)
    
    except Exception, exception:
        PY_LOGGER.error("Sequence[65] catch except of check extent status.")
        PY_LOGGER.error("Sequence[65] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[65] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[65] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet1 + cliRet, errMsg)
