# -*- coding: UTF-8 -*-
import traceback
import re
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : check PreCopy switch
    Input              : cli--Telnet access proxy 
					 e.g: cliRet = cli.execCmd("show storage_pool general")
    Return             : the checkitem is pass;cli source info
    """
    try:
	flag = False
	lang = py_java_env.get("lang")
    	errMsg = ""
	cliRet = cli.execCmd("show disk precopy")
	PY_LOGGER.info("\nSequence[66] execute command result:\n" + cliRet)
	
	list = cliRet.splitlines()
	i = 0
	for field in list:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[66] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式"
                else:
                    errMsg = "\nSystem is not in admin Mode"
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[66]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
            i = i+1
            if i > 2:
                field = field.replace(" ", "")
                if field.startswith("PreCopyEnabled:"):
                    if (field.replace("PreCopyEnabled:", "") == "Yes") or (field.replace("PreCopyEnabled:", "") == "No"):
                        flag = True
                        return(flag, cliRet)
        if "zh" == lang:
            errMsg = u"\n硬盘预拷贝状态异常("+field+u")"
        else:
            errMsg = "\nThe precopy of disk is abnormal("+field+")"
        return (flag, cliRet, errMsg)

    except Exception, exception:
        PY_LOGGER.error("Sequence[66] catch except of check PreCopy switch.")
        PY_LOGGER.error("Sequence[66] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[66] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[66] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
	if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
