# -*- coding: UTF-8 -*-
import traceback
import re
    
def execute(cli):
    """
    Create date        : 2012/05/18,Modify date:2012/06/12
    Function name      : execute(cliConnection)
    Function describe  : execute warning alarm check
    Input              : cli--Telnet access proxy 
                         e.g: cliRet = cli.execCmd("show system general")
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        send_alarm = True
        alarmID = [
         "0xF00150019",
         "0xF0015001A",
         "0xF0015001B",
         "0x100F0015001C",
         "0xF0015001D"]
        errMsg = ""
        cliRet4Return = ""

        for element in alarmID:
            cliRet = ""
            send_alarm = True
            cliRet = cli.execCmd("show alarm |filterRow column=ID predict=equal_to value=" + element)
            PY_LOGGER.info("\nSequence[70] execute command result:\n" + cliRet)
            cliRet4Return += cliRet
            list = cliRet.splitlines()
            for field in list:
                #Need enter to CLI and must in normal mode.
                if field.startswith("-bash") or field.startswith("upgrade"):
                    flag = False
                    PY_LOGGER.info("Sequence[70] not in CLI mode, out!")
                    if "zh" == lang:
                        errMsg = u"\n系统没有运行在admin模式"
                    else:
                        errMsg = "\nSystem is not in admin Mode"
                    return (flag, cliRet, errMsg)
                #其它出现“Error:”字眼的信息视为不通过
                if re.search("Error:", field, re.IGNORECASE):
                    flag = False
                    PY_LOGGER.info("There is an error in Sequence[70]!")
                    if "zh" == lang:
                        errMsg = u"\n获取信息出错。"
                    else:
                        errMsg = "\nThere is an error in getting information."
                    return (flag, cliRet, errMsg)
                
                PY_LOGGER.info("\nFiled=" + field)
                if field.find("Command executed successfully") != -1:
                    send_alarm = False
                else:
                    continue
                
            if send_alarm == True:
                flag = False
                if "zh" == lang:
                    errMsg += u"\n产生的告警ID为： " + element + u"。"
                else:
                    errMsg += "\nThe ID of the alarm is: " + element + "."
        return (flag, cliRet4Return, errMsg)

    except Exception, exception:
        PY_LOGGER.error("Sequence[70] catch except of check warning alarm.")
        PY_LOGGER.error("Sequence[70] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[70] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[70] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet4Return, errMsg)
